/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u001f\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R*\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyDeclarationCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "declaredVariablesInLoop", "<init>", "(Lorg/jetbrains/kotlin/fir/util/SetMultimap;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "whileLoop", "visitWhileLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "doWhileLoop", "visitDoWhileLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "anonymousFunction", "visitAnonymousFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "loop", "visitRepeatable", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "getDeclaredVariablesInLoop", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;"})
final class PropertyDeclarationCollector
extends FirVisitor<Unit, FirStatement> {
    @NotNull
    private final SetMultimap<FirStatement, FirVariableSymbol<?>> declaredVariablesInLoop;

    public PropertyDeclarationCollector(@NotNull SetMultimap<FirStatement, FirVariableSymbol<?>> declaredVariablesInLoop) {
        Intrinsics.checkNotNullParameter(declaredVariablesInLoop, "declaredVariablesInLoop");
        this.declaredVariablesInLoop = declaredVariablesInLoop;
    }

    @NotNull
    public final SetMultimap<FirStatement, FirVariableSymbol<?>> getDeclaredVariablesInLoop() {
        return this.declaredVariablesInLoop;
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        element.acceptChildren(this, data2);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (property.isLocal() && data2 != null) {
            this.declaredVariablesInLoop.put(data2, property.getSymbol());
        }
        this.visitElement((FirElement)property, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter(whileLoop, "whileLoop");
        this.visitRepeatable(whileLoop, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter(doWhileLoop, "doWhileLoop");
        this.visitRepeatable(doWhileLoop, data2);
    }

    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
        EventOccurrencesRange eventOccurrencesRange = anonymousFunction.getInvocationKind();
        boolean bl = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(eventOccurrencesRange) : false;
        if (bl) {
            this.visitRepeatable(anonymousFunction, data2);
        } else {
            this.visitElement((FirElement)anonymousFunction, data2);
        }
    }

    private final void visitRepeatable(FirStatement loop, FirStatement data2) {
        this.visitElement((FirElement)loop, loop);
        if (data2 != null) {
            this.declaredVariablesInLoop.putAll(data2, (Collection<FirVariableSymbol<?>>)this.declaredVariablesInLoop.get(loop));
        }
    }
}

