/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013R\u001a\u0010\b\u001a\u00020\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001b\u001a\u00020\u00048GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "userType", "originalType", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)V", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getArgument", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getUserType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getOriginalType", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "smartCastType$delegate", "Lkotlin/Lazy;", "getSmartCastType", "smartCastType", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "getOriginalTypeInfo", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "originalTypeInfo", "getSmartCastTypeInfo", "smartCastTypeInfo"})
public final class ArgumentInfo {
    @NotNull
    private final FirExpression argument;
    @NotNull
    private final ConeKotlinType userType;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy smartCastType$delegate;

    public ArgumentInfo(@NotNull FirExpression argument, @NotNull ConeKotlinType userType, @NotNull ConeKotlinType originalType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(userType, "userType");
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        Intrinsics.checkNotNullParameter(session, "session");
        this.argument = argument;
        this.userType = userType;
        this.originalType = originalType;
        this.session = session;
        this.smartCastType$delegate = LazyKt.lazy(() -> ArgumentInfo.smartCastType_delegate$lambda$0(this));
    }

    @NotNull
    public final FirExpression getArgument() {
        return this.argument;
    }

    @NotNull
    public final ConeKotlinType getUserType() {
        return this.userType;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ConeKotlinType getSmartCastType() {
        Lazy lazy = this.smartCastType$delegate;
        return (ConeKotlinType)lazy.getValue();
    }

    @NotNull
    public final TypeInfo getOriginalTypeInfo() {
        return FirTypeCompatibilityHelpersKt.toTypeInfo(this.originalType, this.session);
    }

    @NotNull
    public final TypeInfo getSmartCastTypeInfo() {
        return FirTypeCompatibilityHelpersKt.toTypeInfo(this.getSmartCastType(), this.session);
    }

    @NotNull
    public String toString() {
        KtSourceElement ktSourceElement = this.argument.getSource();
        return (ktSourceElement != null ? KtSourceElementKt.getText(ktSourceElement) : null) + " :: " + this.userType;
    }

    private static final ConeKotlinType smartCastType_delegate$lambda$0(ArgumentInfo this$0) {
        return TypeExpansionUtilsKt.fullyExpandedType$default(this$0.userType, this$0.session, null, 2, null);
    }
}

