/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001e\u0010\u0007\u001a\u00020\u0006*\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\tH\u0007\u00a2\u0006\u0004\b\u0002\u0010\n\u001a!\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0019\u0010\u000e\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001d\u0010\u000e\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0011\"\u0019\u0010\u0014\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\"\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u00008AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "getModifierList", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "token", "", "contains", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Z", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "getModifier", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "hasModifier", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Z", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "getValOrVarKeyword", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "valOrVarKeyword"})
public final class FirKeywordUtilsKt {
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FirModifierList getModifierList(@Nullable KtSourceElement $this$getModifierList) {
        FirModifierList firModifierList;
        KtSourceElement ktSourceElement = $this$getModifierList;
        if (ktSourceElement == null) {
            firModifierList = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            FirModifierList.FirPsiModifierList firPsiModifierList;
            KtModifierListOwner modifierListOwner;
            PsiElement psiElement = ((KtPsiSourceElement)$this$getModifierList).getPsi();
            KtModifierListOwner ktModifierListOwner = modifierListOwner = psiElement instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement : null;
            if (Intrinsics.areEqual(((KtPsiSourceElement)$this$getModifierList).getKind(), KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && modifierListOwner instanceof KtProperty) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Don't request modifiers on fake PSI of delegated property accessors, it's not the right PSI";
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$getModifierList_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$getModifierList_u24lambda_u240, "property", modifierListOwner);
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            KtElement ktElement = modifierListOwner;
            if (ktElement != null && (ktElement = ktElement.getModifierList()) != null) {
                KtElement it = ktElement;
                boolean bl = false;
                firPsiModifierList = new FirModifierList.FirPsiModifierList((KtModifierList)it);
            } else {
                firPsiModifierList = null;
            }
            firModifierList = firPsiModifierList;
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            Object v4;
            block11: {
                Iterable iterable = LightTreeUtilsKt.getChildren(((KtLightSourceElement)$this$getModifierList).getLighterASTNode(), ((KtLightSourceElement)$this$getModifierList).getTreeStructure());
                for (Object t : iterable) {
                    LighterASTNode it = (LighterASTNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.MODIFIER_LIST)) continue;
                    v4 = t;
                    break block11;
                }
                v4 = null;
            }
            LighterASTNode lighterASTNode = v4;
            if (lighterASTNode == null) {
                return null;
            }
            LighterASTNode modifierListNode = lighterASTNode;
            int offsetDelta = ((KtLightSourceElement)$this$getModifierList).getStartOffset() - ((KtLightSourceElement)$this$getModifierList).getLighterASTNode().getStartOffset();
            firModifierList = new FirModifierList.FirLightModifierList(modifierListNode, ((KtLightSourceElement)$this$getModifierList).getTreeStructure(), offsetDelta);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firModifierList;
    }

    public static final boolean contains(@Nullable FirModifierList $this$contains, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter(token, "token");
        FirModifierList firModifierList = $this$contains;
        return firModifierList != null ? firModifierList.contains(token) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final FirModifierList getModifierList(@NotNull FirElement $this$getModifierList) {
        Intrinsics.checkNotNullParameter($this$getModifierList, "<this>");
        KtSourceElement ktSourceElement = $this$getModifierList.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            KtSourceElement ktSourceElement2 = $this$getModifierList.getSource();
            if (!Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null, KtNodeTypes.PROPERTY_ACCESSOR)) {
                return null;
            }
        }
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList($this$getModifierList.getSource());
        return firModifierList;
    }

    @Nullable
    public static final FirModifier<?> getModifier(@NotNull FirElement $this$getModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter($this$getModifier, "<this>");
        Intrinsics.checkNotNullParameter(token, "token");
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList($this$getModifier);
        return firModifierList != null ? firModifierList.get(token) : null;
    }

    public static final boolean hasModifier(@NotNull FirElement $this$hasModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter($this$hasModifier, "<this>");
        Intrinsics.checkNotNullParameter(token, "token");
        return FirKeywordUtilsKt.contains(FirKeywordUtilsKt.getModifierList($this$hasModifier), token);
    }

    public static final boolean hasModifier(@NotNull FirBasedSymbol<?> $this$hasModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter($this$hasModifier, "<this>");
        Intrinsics.checkNotNullParameter(token, "token");
        return FirKeywordUtilsKt.hasModifier((FirElement)$this$hasModifier.getFir(), token);
    }

    @Nullable
    public static final KtKeywordToken getValOrVarKeyword(@Nullable KtSourceElement $this$valOrVarKeyword) {
        KtKeywordToken ktKeywordToken;
        KtSourceElement ktSourceElement = $this$valOrVarKeyword;
        if (ktSourceElement == null) {
            ktKeywordToken = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            PsiElement psiElement = ((KtPsiSourceElement)$this$valOrVarKeyword).getPsi();
            PsiElement psiElement2 = psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null;
            if (psiElement2 != null && (psiElement2 = psiElement2.getValOrVarKeyword()) != null) {
                IElementType iElementType;
                PsiElement it = psiElement2;
                boolean bl = false;
                ASTNode aSTNode = it.getNode();
                IElementType iElementType2 = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                ktKeywordToken = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
            } else {
                ktKeywordToken = null;
            }
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            IElementType iElementType;
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword(((KtLightSourceElement)$this$valOrVarKeyword).getTreeStructure(), ((KtLightSourceElement)$this$valOrVarKeyword).getLighterASTNode());
            IElementType iElementType3 = iElementType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
            ktKeywordToken = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktKeywordToken;
    }

    public static final /* synthetic */ TokenSet access$getMODIFIER_KEYWORD_SET$p() {
        return MODIFIER_KEYWORD_SET;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        tokenSetArray[1] = TokenSet.create(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet(tokenSetArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "orSet(...)");
        MODIFIER_KEYWORD_SET = tokenSet;
    }
}

