/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorage;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\t\u001a\u00020\b2\b\u0010\u0001\u001a\u0004\u0018\u00010\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u001a5\u0010\t\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "classifierType", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "checkMissingDependencySuperTypes", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declaration", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z"})
public final class FirMissingDependencySupertypeUtilsKt {
    public static final boolean checkMissingDependencySuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        ConeKotlinType coneKotlinType = classifierType;
        return FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes((FirBasedSymbol)(coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context.getSession()) : null), source, reporter, context);
    }

    public static final boolean checkMissingDependencySuperTypes(@Nullable FirBasedSymbol<?> declaration, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(declaration instanceof FirClassSymbol)) {
            return false;
        }
        Set<FirMissingDependencyStorage.TypeWithOrigin> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context.getSession()).getMissingSuperTypes((FirClassSymbol)declaration);
        for (FirMissingDependencyStorage.TypeWithOrigin typeWithOrigin : missingSuperTypes) {
            ConeKotlinType superType = typeWithOrigin.component1();
            FirMissingDependencyStorage.SupertypeOrigin origin = typeWithOrigin.component2();
            KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> diagnostic = origin == FirMissingDependencyStorage.SupertypeOrigin.TYPE_ARGUMENT && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidUsingSupertypesWithInaccessibleContentInTypeArguments) ? FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_IN_TYPE_ARGUMENT() : FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType, new ConeTypeProjection[0]), false, TypeComponentsKt.getTypeContext(context.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration, null, false, null, 7, null), (DiagnosticContext)context, null, 32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }
}

