/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u0012\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "token", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "get", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "", "contains", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Z", "", "getModifiers", "()Ljava/util/List;", "modifiers", "FirPsiModifierList", "FirLightModifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList$FirLightModifierList;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList$FirPsiModifierList;"})
public abstract class FirModifierList {
    private FirModifierList() {
    }

    @NotNull
    public abstract List<FirModifier<?>> getModifiers();

    @Nullable
    public final FirModifier<?> get(@NotNull KtModifierKeywordToken token) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(token, "token");
            Iterable $this$firstOrNull$iv = this.getModifiers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirModifier it = (FirModifier)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getToken(), token)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean contains(@NotNull KtModifierKeywordToken token) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(token, "token");
            Iterable $this$any$iv = this.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirModifier it = (FirModifier)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getToken(), token)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public /* synthetic */ FirModifierList(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList$FirLightModifierList;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "Lcom/intellij/lang/LighterASTNode;", "modifierList", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "tree", "", "offsetDelta", "<init>", "(Lcom/intellij/lang/LighterASTNode;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;I)V", "Lcom/intellij/lang/LighterASTNode;", "getModifierList", "()Lcom/intellij/lang/LighterASTNode;", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "I", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier;", "getModifiers", "()Ljava/util/List;", "modifiers"})
    public static final class FirLightModifierList
    extends FirModifierList {
        @NotNull
        private final LighterASTNode modifierList;
        @NotNull
        private final FlyweightCapableTreeStructure<LighterASTNode> tree;
        private final int offsetDelta;

        public FirLightModifierList(@NotNull LighterASTNode modifierList2, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, int offsetDelta) {
            Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
            Intrinsics.checkNotNullParameter(tree, "tree");
            super(null);
            this.modifierList = modifierList2;
            this.tree = tree;
            this.offsetDelta = offsetDelta;
        }

        @NotNull
        public final LighterASTNode getModifierList() {
            return this.modifierList;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
            return this.tree;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<FirModifier.FirLightModifier> getModifiers() {
            void $this$mapTo$iv$iv;
            LighterASTNode it;
            Iterable $this$filterTo$iv$iv;
            List<LighterASTNode> modifierNodes = LightTreeUtilsKt.getChildren(this.modifierList, this.tree);
            Iterable $this$filter$iv = modifierNodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                if (!(it.getTokenType() instanceof KtModifierKeywordToken)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LighterASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IElementType iElementType = it.getTokenType();
                Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                collection.add(new FirModifier.FirLightModifier(it, (KtModifierKeywordToken)iElementType, this.tree, this.offsetDelta));
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList$FirPsiModifierList;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "modifierList", "<init>", "(Lorg/jetbrains/kotlin/psi/KtModifierList;)V", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "getModifierList", "()Lorg/jetbrains/kotlin/psi/KtModifierList;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier;", "getModifiers", "()Ljava/util/List;", "modifiers"})
    public static final class FirPsiModifierList
    extends FirModifierList {
        @NotNull
        private final KtModifierList modifierList;

        public FirPsiModifierList(@NotNull KtModifierList modifierList2) {
            Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
            super(null);
            this.modifierList = modifierList2;
        }

        @NotNull
        public final KtModifierList getModifierList() {
            return this.modifierList;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<FirModifier.FirPsiModifier> getModifiers() {
            void $this$mapTo$iv$iv;
            ASTNode[] aSTNodeArray = this.modifierList.getNode().getChildren(FirKeywordUtilsKt.access$getMODIFIER_KEYWORD_SET$p());
            Intrinsics.checkNotNullExpressionValue(aSTNodeArray, "getChildren(...)");
            Object[] $this$map$iv = aSTNodeArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void node;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(node);
                IElementType iElementType = node.getElementType();
                Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                collection.add(new FirModifier.FirPsiModifier((ASTNode)node, (KtModifierKeywordToken)iElementType));
            }
            return (List)destination$iv$iv;
        }
    }
}

