/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\t\u001a\u00020\b*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\t\u0010\fJ\u001f\u0010\t\u001a\u00020\b*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\t\u0010\u000eJ#\u0010\u0010\u001a\u00020\b*\u00060\u0004j\u0002`\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\b*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00172\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u001aJ\u001b\u0010\u0018\u001a\u00020\u00172\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u001cJ\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u001eJ\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b\u0018\u0010 J\u001b\u0010\"\u001a\u00020\u00172\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030!H\u0002\u00a2\u0006\u0004\b\"\u0010#J#\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030!H\u0007\u00a2\u0006\u0004\b\u0018\u0010&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter;", "", "<init>", "()V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/name/ClassId;", "it", "", "appendRepresentation", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/name/ClassId;)V", "Lorg/jetbrains/kotlin/name/CallableId;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/name/CallableId;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "appendRepresentationBeforeCallableId", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "appendValueParameters", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)V", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declaration", "", "represent", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/lang/String;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "representClassLike", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "owner", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Ljava/lang/String;"})
public final class FirRedeclarationPresenter {
    @NotNull
    public static final FirRedeclarationPresenter INSTANCE = new FirRedeclarationPresenter();

    private FirRedeclarationPresenter() {
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, ClassId it) {
        $this$appendRepresentation.append(it.getPackageFqName().asString());
        $this$appendRepresentation.append('/');
        $this$appendRepresentation.append(it.getRelativeClassName().asString());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, CallableId it) {
        $this$appendRepresentation.append(it.getPackageName().asString());
        $this$appendRepresentation.append('/');
        if (it.getClassName() != null) {
            $this$appendRepresentation.append(it.getClassName());
            $this$appendRepresentation.append('.');
        }
        $this$appendRepresentation.append(it.getCallableName());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, FirValueParameterSymbol it) {
        if (it.isVararg()) {
            $this$appendRepresentation.append("vararg ");
        }
    }

    private final void appendRepresentationBeforeCallableId(StringBuilder $this$appendRepresentationBeforeCallableId, FirCallableSymbol<?> it) {
        int it2;
        int n = it.getResolvedContextParameters().size();
        int n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('<');
        n = it.getTypeParameterSymbols().size();
        n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('>');
        $this$appendRepresentationBeforeCallableId.append('[');
        FirPureAbstractElement firPureAbstractElement = it.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it3 = firPureAbstractElement;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append(']');
    }

    private final void appendValueParameters(StringBuilder $this$appendValueParameters, FirNamedFunctionSymbol it) {
        $this$appendValueParameters.append('(');
        Iterable $this$forEach$iv = it.getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol it2 = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
            INSTANCE.appendRepresentation($this$appendValueParameters, it2);
            $this$appendValueParameters.append(',');
        }
        $this$appendValueParameters.append(')');
    }

    @Nullable
    public final String represent(@NotNull FirBasedSymbol<?> declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirBasedSymbol<?> firBasedSymbol = declaration;
        return firBasedSymbol instanceof FirNamedFunctionSymbol ? this.represent((FirNamedFunctionSymbol)declaration) : (firBasedSymbol instanceof FirRegularClassSymbol ? this.represent((FirRegularClassSymbol)declaration) : (firBasedSymbol instanceof FirTypeAliasSymbol ? this.represent((FirTypeAliasSymbol)declaration) : (firBasedSymbol instanceof FirPropertySymbol ? this.represent((FirVariableSymbol)declaration) : null)));
    }

    @NotNull
    public final String represent(@NotNull FirNamedFunctionSymbol it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(it, "it");
        StringBuilder $this$represent_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u244, it);
        INSTANCE.appendRepresentation($this$represent_u24lambda_u244, it.getCallableId());
        INSTANCE.appendValueParameters($this$represent_u24lambda_u244, it);
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirVariableSymbol<?> it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(it, "it");
        StringBuilder $this$represent_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u245, (FirCallableSymbol)it);
        INSTANCE.appendRepresentation($this$represent_u24lambda_u245, it.getCallableId());
        if (it instanceof FirFieldSymbol) {
            $this$represent_u24lambda_u245.append("#f");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirTypeAliasSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.representClassLike(it);
    }

    @NotNull
    public final String represent(@NotNull FirRegularClassSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.representClassLike(it);
    }

    private final String representClassLike(FirClassLikeSymbol<?> it) {
        StringBuilder stringBuilder;
        StringBuilder $this$representClassLike_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$representClassLike_u24lambda_u246.append('<');
        $this$representClassLike_u24lambda_u246.append('>');
        $this$representClassLike_u24lambda_u246.append('[');
        $this$representClassLike_u24lambda_u246.append(']');
        INSTANCE.appendRepresentation($this$representClassLike_u24lambda_u246, it.getClassId());
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirConstructorSymbol it, @NotNull FirClassLikeSymbol<?> owner) {
        int it2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(owner, "owner");
        StringBuilder $this$represent_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = it.getResolvedContextParameters().size();
        int n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl2 = false;
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('<');
        n = it.getTypeParameterSymbols().size();
        n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl3 = false;
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('>');
        $this$represent_u24lambda_u2410.append('[');
        $this$represent_u24lambda_u2410.append(']');
        INSTANCE.appendRepresentation($this$represent_u24lambda_u2410, owner.getClassId());
        $this$represent_u24lambda_u2410.append('(');
        Iterable $this$forEach$iv = it.getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol it3 = (FirValueParameterSymbol)element$iv;
            boolean bl4 = false;
            INSTANCE.appendRepresentation($this$represent_u24lambda_u2410, it3);
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append(')');
        return stringBuilder.toString();
    }
}

