/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtTypeProjectionElementType;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\t\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0004*\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\f*\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\f*\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0018\u001a\u00020\f*\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\f*\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u000eJ7\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001f0\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010\u001c*\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u0004\u0018\u00010\f*\u00020%H\u0017\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u0004\u0018\u00010\f*\u00020%H\u0017\u00a2\u0006\u0004\b(\u0010'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "<init>", "()V", "T", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/KtSourceElement;", "f", "withSource", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "", "isInConstructorCallee", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "isInTypeConstraint", "", "getRawIdentifier", "(Lorg/jetbrains/kotlin/KtSourceElement;)Ljava/lang/CharSequence;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "getRawName", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isCatchElementParameter", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;)Z", "isRedundantNullable", "source", "Lcom/intellij/lang/LighterASTNode;", "node", "Lcom/intellij/openapi/util/Ref;", "", "ref", "getNullableChild", "(Lorg/jetbrains/kotlin/KtSourceElement;Lcom/intellij/lang/LighterASTNode;Lcom/intellij/openapi/util/Ref;)Lcom/intellij/lang/LighterASTNode;", "getParentOfParent", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lcom/intellij/lang/LighterASTNode;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "hasBody", "(Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;)Ljava/lang/Boolean;", "hasInitializer"})
class LightTreeSourceNavigator
implements SourceNavigator {
    private final <T> T withSource(FirElement $this$withSource, Function1<? super KtSourceElement, ? extends T> f) {
        T t;
        KtSourceElement ktSourceElement = $this$withSource.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            t = f.invoke(it);
        } else {
            t = null;
        }
        return t;
    }

    @Override
    public boolean isInConstructorCallee(@NotNull FirTypeRef $this$isInConstructorCallee) {
        Intrinsics.checkNotNullParameter($this$isInConstructorCallee, "<this>");
        Boolean bl = this.withSource($this$isInConstructorCallee, LightTreeSourceNavigator::isInConstructorCallee$lambda$1);
        return bl != null ? bl : false;
    }

    @Override
    public boolean isInTypeConstraint(@NotNull FirTypeRef $this$isInTypeConstraint) {
        LighterASTNode lighterASTNode;
        block2: {
            Intrinsics.checkNotNullParameter($this$isInTypeConstraint, "<this>");
            KtSourceElement ktSourceElement = $this$isInTypeConstraint.getSource();
            if (ktSourceElement == null) {
                return false;
            }
            KtSourceElement source = ktSourceElement;
            Sequence<LighterASTNode> sequence2 = LightTreePositioningStrategiesKt.getAncestors(source.getTreeStructure(), source.getLighterASTNode());
            Iterator<LighterASTNode> iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                LighterASTNode lighterASTNode2;
                LighterASTNode it = lighterASTNode2 = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_CONSTRAINT) || Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_PARAMETER))) continue;
                lighterASTNode = lighterASTNode2;
                break block2;
            }
            lighterASTNode = null;
        }
        LighterASTNode lighterASTNode3 = lighterASTNode;
        return Intrinsics.areEqual(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null, KtNodeTypes.TYPE_CONSTRAINT);
    }

    @Override
    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement $this$getRawIdentifier) {
        Intrinsics.checkNotNullParameter($this$getRawIdentifier, "<this>");
        IElementType iElementType = $this$getRawIdentifier.getElementType();
        return iElementType instanceof KtNameReferenceExpressionElementType || Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER) ? (CharSequence)$this$getRawIdentifier.getLighterASTNode().toString() : (iElementType instanceof KtTypeProjectionElementType ? (CharSequence)CollectionsKt.last(LightTreeUtilsKt.getChildren($this$getRawIdentifier.getLighterASTNode(), $this$getRawIdentifier.getTreeStructure())).toString() : null);
    }

    @Override
    @Nullable
    public String getRawName(@NotNull FirDeclaration $this$getRawName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$getRawName, "<this>");
        KtSourceElement ktSourceElement = $this$getRawName.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.nameIdentifier(it.getTreeStructure(), it.getLighterASTNode());
            string2 = lighterASTNode != null ? lighterASTNode.toString() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol $this$isCatchElementParameter) {
        Intrinsics.checkNotNullParameter($this$isCatchElementParameter, "<this>");
        Object object = $this$isCatchElementParameter.getSource();
        return Intrinsics.areEqual(object != null && (object = this.getParentOfParent((KtSourceElement)object)) != null ? object.getTokenType() : null, KtNodeTypes.CATCH);
    }

    @Override
    public boolean isRedundantNullable(@NotNull FirTypeRef $this$isRedundantNullable) {
        Intrinsics.checkNotNullParameter($this$isRedundantNullable, "<this>");
        KtSourceElement ktSourceElement = $this$isRedundantNullable.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        Ref<LighterASTNode[]> ref = new Ref<LighterASTNode[]>();
        LighterASTNode lighterASTNode = this.getNullableChild(source, source.getLighterASTNode(), ref);
        if (lighterASTNode == null) {
            return false;
        }
        LighterASTNode firstChild = lighterASTNode;
        return this.getNullableChild(source, firstChild, ref) != null;
    }

    private final LighterASTNode getNullableChild(KtSourceElement source, LighterASTNode node, Ref<LighterASTNode[]> ref) {
        source.getTreeStructure().getChildren(node, ref);
        LighterASTNode[] lighterASTNodeArray = ref.get();
        Intrinsics.checkNotNullExpressionValue(lighterASTNodeArray, "get(...)");
        LighterASTNode lighterASTNode = (LighterASTNode)ArraysKt.firstOrNull((Object[])lighterASTNodeArray);
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode firstChild = lighterASTNode;
        return !Intrinsics.areEqual(firstChild.getTokenType(), KtNodeTypes.NULLABLE_TYPE) ? null : firstChild;
    }

    private final LighterASTNode getParentOfParent(KtSourceElement $this$getParentOfParent) {
        LighterASTNode parent2;
        block1: {
            KtSourceElement ktSourceElement = $this$getParentOfParent;
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            parent2 = null;
            LighterASTNode lighterASTNode = parent2 = source.getTreeStructure().getParent(source.getLighterASTNode());
            if (lighterASTNode == null) break block1;
            LighterASTNode it = lighterASTNode;
            boolean bl = false;
            parent2 = source.getTreeStructure().getParent(it);
        }
        return parent2;
    }

    @Override
    @Nullable
    public Boolean hasBody(@NotNull FirEnumEntry $this$hasBody) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$hasBody, "<this>");
            KtSourceElement ktSourceElement = $this$hasBody.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            List<LighterASTNode> childNodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
            Iterable $this$any$iv = childNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.CLASS_BODY)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Boolean hasInitializer(@NotNull FirEnumEntry $this$hasInitializer) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$hasInitializer, "<this>");
            KtSourceElement ktSourceElement = $this$hasInitializer.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            List<LighterASTNode> childNodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
            Iterable $this$any$iv = childNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.INITIALIZER_LIST)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isInConstructorCallee$lambda$1(KtSourceElement source) {
        Intrinsics.checkNotNullParameter(source, "source");
        LighterASTNode lighterASTNode = source.getTreeStructure().getParent(source.getLighterASTNode());
        return Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtNodeTypes.CONSTRUCTOR_CALLEE);
    }
}

