/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001b\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "toVisibilityOrNull", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "findContextReceiverListSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/KtLightSourceElement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "delegatedPropertySourceOrThis", "(Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/KtSourceElement;"})
public final class SourceHelpersKt {
    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter($this$toVisibilityOrNull, "<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final KtLightSourceElement findContextReceiverListSource(@NotNull KtSourceElement $this$findContextReceiverListSource) {
        void $this$toKtLightSourceElement_u24default$iv;
        Intrinsics.checkNotNullParameter($this$findContextReceiverListSource, "<this>");
        if (Intrinsics.areEqual($this$findContextReceiverListSource.getLighterASTNode().getTokenType(), KtNodeTypes.CONTEXT_RECEIVER_LIST)) {
            void $this$toKtLightSourceElement_u24default$iv2;
            LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv2.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv2.getEndOffset();
            return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv2, startOffset$iv, endOffset$iv, tree$iv, kind$iv);
        }
        if (Intrinsics.areEqual($this$findContextReceiverListSource.getLighterASTNode().getTokenType(), KtNodeTypes.TYPE_REFERENCE)) {
            void $this$toKtLightSourceElement_u24default$iv3;
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$findContextReceiverListSource.getTreeStructure();
            LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
            IElementType iElementType = KtNodeTypes.FUNCTION_TYPE;
            Intrinsics.checkNotNullExpressionValue(iElementType, "FUNCTION_TYPE");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(flyweightCapableTreeStructure, lighterASTNode, iElementType);
            if (lighterASTNode2 == null) return null;
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure2 = $this$findContextReceiverListSource.getTreeStructure();
            IElementType iElementType2 = KtNodeTypes.CONTEXT_RECEIVER_LIST;
            Intrinsics.checkNotNullExpressionValue(iElementType2, "CONTEXT_RECEIVER_LIST");
            LighterASTNode tree$iv = LightTreePositioningStrategiesKt.findChildByType(flyweightCapableTreeStructure2, it, iElementType2);
            if (tree$iv == null) return null;
            LighterASTNode kind$iv = tree$iv;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv2 = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv2 = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv3.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv3.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            KtLightSourceElement ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv3, startOffset$iv, endOffset$iv, tree$iv2, kind$iv2);
            return ktLightSourceElement;
        }
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$findContextReceiverListSource.getTreeStructure();
        LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
        IElementType iElementType = KtNodeTypes.CONTEXT_RECEIVER_LIST;
        Intrinsics.checkNotNullExpressionValue(iElementType, "CONTEXT_RECEIVER_LIST");
        LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(flyweightCapableTreeStructure, lighterASTNode, iElementType);
        if (lighterASTNode3 == null) return null;
        LighterASTNode tree$iv = lighterASTNode3;
        FlyweightCapableTreeStructure<LighterASTNode> tree$iv3 = $this$findContextReceiverListSource.getTreeStructure();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
        int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
        boolean $i$f$toKtLightSourceElement = false;
        KtLightSourceElement ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv3, kind$iv);
        return ktLightSourceElement;
    }

    @NotNull
    public static final KtSourceElement delegatedPropertySourceOrThis(@NotNull KtSourceElement $this$delegatedPropertySourceOrThis, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$delegatedPropertySourceOrThis, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        if (Intrinsics.areEqual($this$delegatedPropertySourceOrThis.getKind(), KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            KtSourceElement ktSourceElement;
            KtSourceElement ktSourceElement2;
            FirExpression firExpression;
            Iterator<Object> iterator2;
            block7: {
                Iterable $this$lastIsInstanceOrNull$iv = context.getContainingDeclarations();
                boolean $i$f$lastIsInstanceOrNull = false;
                if ($this$lastIsInstanceOrNull$iv instanceof List) {
                    int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                    if (0 <= n) {
                        do {
                            int i$iv;
                            Iterator<Object> element$iv;
                            if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirProperty)) continue;
                            iterator2 = element$iv;
                            break block7;
                        } while (0 <= n);
                    }
                    iterator2 = null;
                } else {
                    Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed($this$lastIsInstanceOrNull$iv);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof FirProperty)) continue;
                        iterator2 = (Iterator<Object>)element$iv$iv;
                        break block7;
                    }
                    iterator2 = null;
                }
            }
            FirProperty property = (FirProperty)((Object)iterator2);
            if (property != null && (firExpression = property.getDelegate()) != null && (ktSourceElement2 = firExpression.getSource()) != null && (ktSourceElement = KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) != null) {
                KtSourceElement it = ktSourceElement;
                boolean bl = false;
                return it;
            }
        }
        return $this$delegatedPropertySourceOrThis;
    }
}

