/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.PsiSourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\u0013\u0010\u0004\u001a\u00020\u0003*\u00020\u0002H&\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u0003*\u00020\u0002H&\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u0015\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u0007H'\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u000bH'\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0010\u001a\u00020\u0003*\u00020\u000fH&\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u0003*\u00020\u0002H&\u00a2\u0006\u0004\b\u0012\u0010\u0005J\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u0013H'\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\u0013H'\u00a2\u0006\u0004\b\u0016\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "", "isInConstructorCallee", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "isInTypeConstraint", "Lorg/jetbrains/kotlin/KtSourceElement;", "", "getRawIdentifier", "(Lorg/jetbrains/kotlin/KtSourceElement;)Ljava/lang/CharSequence;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "getRawName", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isCatchElementParameter", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;)Z", "isRedundantNullable", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "hasBody", "(Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;)Ljava/lang/Boolean;", "hasInitializer", "Companion"})
public interface SourceNavigator {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator$Companion.$$INSTANCE;

    public boolean isInConstructorCallee(@NotNull FirTypeRef var1);

    public boolean isInTypeConstraint(@NotNull FirTypeRef var1);

    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement var1);

    @Nullable
    public String getRawName(@NotNull FirDeclaration var1);

    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol var1);

    public boolean isRedundantNullable(@NotNull FirTypeRef var1);

    @Nullable
    public Boolean hasBody(@NotNull FirEnumEntry var1);

    @Nullable
    public Boolean hasInitializer(@NotNull FirEnumEntry var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u000f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\f*\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/FirElement;", "e", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "forElement", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "Lorg/jetbrains/kotlin/KtSourceElement;", "forSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "R", "Lkotlin/Function1;", "block", "withNavigator", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "lightTreeInstance", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final LightTreeSourceNavigator lightTreeInstance;

        private Companion() {
        }

        @NotNull
        public final SourceNavigator forElement(@NotNull FirElement e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return this.forSource(e.getSource());
        }

        @NotNull
        public final SourceNavigator forSource(@Nullable KtSourceElement e) {
            SourceNavigator sourceNavigator;
            KtSourceElement ktSourceElement = e;
            if (ktSourceElement instanceof KtLightSourceElement) {
                sourceNavigator = lightTreeInstance;
            } else if (ktSourceElement instanceof KtPsiSourceElement) {
                sourceNavigator = PsiSourceNavigator.INSTANCE;
            } else if (ktSourceElement == null) {
                sourceNavigator = lightTreeInstance;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return sourceNavigator;
        }

        public final <R> R withNavigator(@NotNull FirElement $this$withNavigator, @NotNull Function1<? super SourceNavigator, ? extends R> block) {
            Intrinsics.checkNotNullParameter($this$withNavigator, "<this>");
            Intrinsics.checkNotNullParameter(block, "block");
            boolean $i$f$withNavigator = false;
            return block.invoke(this.forSource($this$withNavigator.getSource()));
        }

        static {
            $$INSTANCE = new Companion();
            lightTreeInstance = new LightTreeSourceNavigator();
        }
    }
}

