/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirContextReceiversLanguageVersionSettingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;)V", "", "shouldSuggestContextParameters", "Z", "", "CONTEXT_RECEIVER_MESSAGE", "Ljava/lang/String;", "getCONTEXT_RECEIVER_MESSAGE", "()Ljava/lang/String;"})
public final class FirContextReceiversLanguageVersionSettingsChecker
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirContextReceiversLanguageVersionSettingsChecker INSTANCE = new FirContextReceiversLanguageVersionSettingsChecker();
    private static final boolean shouldSuggestContextParameters = LanguageVersion.LATEST_STABLE.compareTo((Enum)LanguageVersion.KOTLIN_2_2) >= 0;
    @NotNull
    private static final String CONTEXT_RECEIVER_MESSAGE = shouldSuggestContextParameters ? "Experimental context receivers are superseded by context parameters.\nReplace the '-Xcontext-receivers' compiler argument with '-Xcontext-parameters' and migrate to the new syntax.\n\nSee the context parameters proposal for more details: https://kotl.in/context-parameters\nThis warning will become an error in future releases." : StringsKt.trimIndent("\n            Experimental context receivers are deprecated and will be superseded by context parameters.\n            Kotlin compiler version " + LanguageVersion.KOTLIN_2_2 + " will be the last version that supports context receivers.\n            Consider migrating to extension receivers or regular parameters now.\n            Alternatively, migrate directly to context parameters when Kotlin " + LanguageVersion.KOTLIN_2_2 + " is released.\n\n            See the context parameters proposal for more details: https://kotl.in/context-parameters\n            This warning will become an error in future releases.");

    private FirContextReceiversLanguageVersionSettingsChecker() {
    }

    @NotNull
    public final String getCONTEXT_RECEIVER_MESSAGE() {
        return CONTEXT_RECEIVER_MESSAGE;
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull BaseDiagnosticsCollector.RawReporter reporter) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters)) {
            reporter.reportError("Experimental language features for context receivers and context parameters cannot be enabled at the same time. Remove the '-Xcontext-receivers' compiler argument.");
        } else if (shouldSuggestContextParameters) {
            reporter.reportWarning(CONTEXT_RECEIVER_MESSAGE);
        }
    }
}

