/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.FirAnonymousUnusedParamChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\t8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\r8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00118'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00118'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00118'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0014\u0010\"\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010'\u001a\u0004\u0018\u00010$8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010+\u001a\u0004\u0018\u00010(8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020-0,8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00102\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010#R\u0014\u00104\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010#R\u0014\u00106\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010#R\u0011\u0010:\u001a\u0002078G\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0011\u0010>\u001a\u00020;8G\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010B\u001a\u00020?8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010F\u001a\u0004\u0018\u00010C8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0016\u0010I\u001a\u0004\u0018\u00010-8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "diagnostic", "", "isDiagnosticSuppressed", "(Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;)Z", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "returnTypeCalculator", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "()Ljava/util/List;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getCallsOrAssignments", "callsOrAssignments", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "getClassCalls", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getAnnotationContainers", "annotationContainers", "Lorg/jetbrains/kotlin/fir/FirElement;", "getContainingElements", "containingElements", "isContractBody", "()Z", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "getInlineFunctionBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "inlineFunctionBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "getLambdaBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "lambdaBodyContext", "", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "suppressedDiagnostics", "getAllInfosSuppressed", "allInfosSuppressed", "getAllWarningsSuppressed", "allWarningsSuppressed", "getAllErrorsSuppressed", "allErrorsSuppressed", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingFile", "getContainingFilePath", "()Ljava/lang/String;", "containingFilePath"})
public abstract class CheckerContext
implements DiagnosticContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirStatement> getCallsOrAssignments();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract List<FirAnnotationContainer> getAnnotationContainers();

    @NotNull
    public abstract List<FirElement> getContainingElements();

    public abstract boolean isContractBody();

    @Nullable
    public abstract FirInlineDeclarationChecker.InlineFunctionBodyContext getInlineFunctionBodyContext();

    @Nullable
    public abstract FirAnonymousUnusedParamChecker.LambdaBodyContext getLambdaBodyContext();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.getSessionHolder().getScopeSession();
    }

    @Override
    public boolean isDiagnosticSuppressed(@NotNull KtDiagnostic diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        AbstractKtDiagnosticFactory factory2 = diagnostic.getFactory();
        String name = factory2.getName();
        if (Intrinsics.areEqual(name, FirErrors.INSTANCE.getERROR_SUPPRESSION().getName())) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name);
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession());
    }

    @Nullable
    public abstract FirFile getContainingFile();

    @Override
    @Nullable
    public String getContainingFilePath() {
        Object object = this.getContainingFile();
        return object != null && (object = ((FirFile)object).getSourceFile()) != null ? object.getPath() : null;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

