/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversPropertyBackingFieldChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirContextReceiversPropertyBackingFieldChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirContextReceiversPropertyBackingFieldChecker INSTANCE = new FirContextReceiversPropertyBackingFieldChecker();

    private FirContextReceiversPropertyBackingFieldChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers) && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters)) {
            return;
        }
        if (declaration.getContextParameters().isEmpty()) {
            return;
        }
        if (DeclarationAttributesKt.getHasBackingField(declaration)) {
            FirMemberDeclaration $this$isLateInit$iv = declaration;
            boolean $i$f$isLateInit = false;
            if (!$this$isLateInit$iv.getStatus().isLateInit()) {
                Object object = declaration.getInitializer();
                if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                    object = declaration.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)object, FirErrors.INSTANCE.getCONTEXT_PARAMETERS_WITH_BACKING_FIELD(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }
}

