/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "originalBounds", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "unwrapBound", "extractTypeParamNames", "", "Lorg/jetbrains/kotlin/name/Name;", "ref", "extractTypeParamName", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
public final class FirCyclicTypeBoundsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirCyclicTypeBoundsChecker INSTANCE = new FirCyclicTypeBoundsChecker();

    private FirCyclicTypeBoundsChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirTypeRef it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration instanceof FirConstructor || declaration instanceof FirTypeAlias) {
            return;
        }
        Set processed = new LinkedHashSet();
        Set cycles = new LinkedHashSet();
        Iterable $this$associate$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Map map2 = destination$iv$iv;
            Object param = (FirTypeParameterRef)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = param.getSymbol().getResolvedBounds();
            Name name = param.getSymbol().getName();
            boolean $i$f$flatMap = false;
            void var21_37 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                it = (FirResolvedTypeRef)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = INSTANCE.extractTypeParamNames(it);
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            param = TuplesKt.to(name, CollectionsKt.toSet((List)destination$iv$iv2));
            map2.put(((Pair)param).getFirst(), ((Pair)param).getSecond());
        }
        Map graph2 = destination$iv$iv;
        Function1<Name, Set> graphFunc = arg_0 -> FirCyclicTypeBoundsChecker.check$lambda$2(graph2, arg_0);
        List path = new ArrayList();
        Iterable $this$forEach$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
            boolean bl = false;
            FirCyclicTypeBoundsChecker.check$findCycles(processed, path, graphFunc, cycles, param.getSymbol().getName());
        }
        if (!((Collection)cycles).isEmpty()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$forEach$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeParameterRef it2 = (FirTypeParameterRef)element$iv$iv;
                boolean bl3 = false;
                if (!cycles.contains(it2.getSymbol().getName())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
                boolean bl = false;
                if (declaration instanceof FirRegularClass) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2 = INSTANCE.originalBounds(param.getSymbol());
                    boolean $i$f$filter2 = false;
                    Iterable bl3 = $this$filter$iv2;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        FirTypeRef it3 = (FirTypeRef)element$iv$iv;
                        boolean bl4 = false;
                        if (!CollectionsKt.contains(cycles, INSTANCE.extractTypeParamName(FirTypeUtilsKt.getConeType(it3)))) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    $this$filter$iv2 = (List)destination$iv$iv4;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
                    destination$iv$iv4 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        KtSourceElement it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl5 = false;
                        it = (FirTypeRef)element$iv$iv;
                        boolean bl6 = false;
                        if (it.getSource() == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv4.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv4;
                } else {
                    list = CollectionsKt.listOf(param.getSource());
                }
                List targets = list;
                Iterable $this$forEach$iv2 = targets;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KtSourceElement it4 = (KtSourceElement)element$iv2;
                    boolean bl8 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it4, FirErrors.INSTANCE.getCYCLIC_GENERIC_UPPER_BOUND(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> originalBounds(FirTypeParameterSymbol $this$originalBounds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$originalBounds.getResolvedBounds();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.unwrapBound(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FirTypeRef> unwrapBound(FirTypeRef $this$unwrapBound) {
        List list;
        if ($this$unwrapBound instanceof FirErrorTypeRef && ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic() instanceof ConeCyclicTypeBound) {
            ConeDiagnostic coneDiagnostic = ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic();
            Intrinsics.checkNotNull(coneDiagnostic, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound");
            list = ((ConeCyclicTypeBound)coneDiagnostic).getBounds();
        } else {
            list = CollectionsKt.listOf($this$unwrapBound);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Name> extractTypeParamNames(FirTypeRef ref) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.unwrapBound(ref);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Name it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.extractTypeParamName(FirTypeUtilsKt.getConeType(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final Name extractTypeParamName(ConeKotlinType type2) {
        ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type2);
        Object object = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
        return object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getName() : null;
    }

    private static final Set check$lambda$2(Map $graph, Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return $graph.getOrDefault(name, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$findCycles(Set<Name> processed, List<Name> path, Function1<? super Name, ? extends Set<Name>> graphFunc, Set<Name> cycles, Name node) {
        Comparable comparable;
        if (processed.add(node)) {
            path.add(node);
            Iterable $this$forEach$iv = graphFunc.invoke(node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Name nextNode = (Name)element$iv;
                boolean bl = false;
                FirCyclicTypeBoundsChecker.check$findCycles(processed, path, graphFunc, cycles, nextNode);
            }
            comparable = path.remove(path.size() - 1);
        } else {
            void $this$dropWhile$iv;
            Iterable $this$forEach$iv = path;
            Set<Name> set = cycles;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                Name it = (Name)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it, node)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            comparable = Boolean.valueOf(set.addAll(list$iv));
        }
    }
}

