/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDataClassConsistentDataCopyAnnotationChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirDataClassConsistentDataCopyAnnotationChecker INSTANCE = new FirDataClassConsistentDataCopyAnnotationChecker();

    private FirDataClassConsistentDataCopyAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Visibility visibility;
        FirAnnotation exposedCopy;
        FirAnnotation consistentCopy;
        block12: {
            block13: {
                boolean $i$f$isData;
                FirRegularClass $this$isData$iv;
                block10: {
                    block11: {
                        Intrinsics.checkNotNullParameter(declaration, "declaration");
                        Intrinsics.checkNotNullParameter(context, "context");
                        Intrinsics.checkNotNullParameter(reporter, "reporter");
                        consistentCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), context.getSession());
                        exposedCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), context.getSession());
                        if (consistentCopy == null) break block10;
                        if (!(declaration instanceof FirRegularClass)) break block11;
                        $this$isData$iv = (FirRegularClass)declaration;
                        $i$f$isData = false;
                        if ($this$isData$iv.getStatus().isData()) break block10;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
                if (exposedCopy == null) break block12;
                if (!(declaration instanceof FirRegularClass)) break block13;
                $this$isData$iv = (FirRegularClass)declaration;
                $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block12;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (consistentCopy != null && exposedCopy != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), (DiagnosticContext)context, null, 8, null);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), (DiagnosticContext)context, null, 8, null);
        }
        FirDataClassConsistentDataCopyAnnotationChecker $this$check_u24lambda_u240 = this;
        boolean bl = false;
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context.getSession());
        if (firConstructorSymbol != null) {
            FirCallableSymbol $this$visibility$iv = firConstructorSymbol;
            boolean $i$f$getVisibility = false;
            visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        } else {
            visibility = null;
        }
        Visibility primaryConstructorVisibility = visibility;
        boolean isPrimaryConstructorVisibilityPublic = Intrinsics.areEqual(primaryConstructorVisibility, Visibilities.Public.INSTANCE);
        boolean isConstructorVisibilityRespected = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DataClassCopyRespectsConstructorVisibility);
        if (consistentCopy != null && (isPrimaryConstructorVisibilityPublic || isConstructorVisibilityRespected)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), (Object)StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), (DiagnosticContext)context, null, 16, null);
        }
        if (exposedCopy == null) return;
        if (!isPrimaryConstructorVisibilityPublic) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), (Object)StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), (DiagnosticContext)context, null, 16, null);
    }
}

