/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionReturnChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkHasReturnIfBlock", "checkers"})
public final class FirFunctionReturnChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionReturnChecker INSTANCE = new FirFunctionReturnChecker();

    private FirFunctionReturnChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkHasReturnIfBlock(declaration, reporter, context);
    }

    private final void checkHasReturnIfBlock(FirFunction declaration, DiagnosticReporter reporter, CheckerContext context) {
        CFGNode<?> cFGNode;
        block8: {
            if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isSetter()) {
                return;
            }
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration).isLambda()) {
                return;
            }
            ConeKotlinType returnType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession(), null, 2, null);
            if (ConeBuiltinTypeUtilsKt.isUnit(returnType)) {
                return;
            }
            Object object = declaration.getControlFlowGraphReference();
            if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
                return;
            }
            Object graph2 = object;
            List<CFGNode<?>> $this$lastOrNull$iv = ((ControlFlowGraph)graph2).getExitNode().getPreviousNodes();
            boolean $i$f$lastOrNull = false;
            ListIterator<CFGNode<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                CFGNode<?> element$iv;
                CFGNode<?> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof BlockExitNode)) continue;
                cFGNode = element$iv;
                break block8;
            }
            cFGNode = null;
        }
        CFGNode cFGNode2 = cFGNode;
        if (cFGNode2 == null) {
            return;
        }
        CFGNode blockExitNode = cFGNode2;
        if (!blockExitNode.isDead()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

