/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirImplicitNothingReturnTypeChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirImplicitNothingReturnTypeChecker INSTANCE = new FirImplicitNothingReturnTypeChecker();

    private FirImplicitNothingReturnTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration instanceof FirSimpleFunction) && !(declaration instanceof FirProperty)) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isLocal()) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        if (Intrinsics.areEqual(declaration.getOrigin(), FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        if (DeclarationUtilsKt.getHasExplicitReturnType(declaration.getSymbol())) {
            boolean notDeclaredAsNothing = !ConeBuiltinTypeUtilsKt.isNothing(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef())));
            boolean expandedNothing = ConeBuiltinTypeUtilsKt.isNothing(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession(), null, 2, null));
            if (notDeclaredAsNothing && expandedNothing) {
                KtDiagnosticFactory0 ktDiagnosticFactory0;
                FirCallableDeclaration firCallableDeclaration = declaration;
                if (firCallableDeclaration instanceof FirSimpleFunction) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_RETURN_TYPE();
                } else if (firCallableDeclaration instanceof FirProperty) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_PROPERTY_TYPE();
                } else {
                    throw new IllegalStateException("Should not be here".toString());
                }
                KtDiagnosticFactory0 factory2 = ktDiagnosticFactory0;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration)).getSource(), factory2, (DiagnosticContext)context, null, 8, null);
            }
            return;
        }
        if (ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirCallableDeclaration firCallableDeclaration = declaration;
            if (firCallableDeclaration instanceof FirSimpleFunction) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_RETURN_TYPE();
            } else if (firCallableDeclaration instanceof FirProperty) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_PROPERTY_TYPE();
            } else {
                throw new IllegalStateException("Should not be here".toString());
            }
            KtDiagnosticFactory0 factory3 = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration)).getSource(), factory3, (DiagnosticContext)context, null, 8, null);
        }
    }
}

