/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0002H\u0002J&\u0010\u0010\u001a\u00020\u0007*\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasGetter", "", "hasSetter", "reportError", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "target", "", "checkers"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isLateInit$iv = declaration;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit() || declaration.getReturnTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (declaration.isVal()) {
            this.reportError(reporter, declaration.getSource(), "is allowed only on mutable properties", context);
        }
        if (declaration.getInitializer() != null) {
            if (declaration.isLocal()) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on local variables with initializer", context);
            } else {
                this.reportError(reporter, declaration.getSource(), "is not allowed on properties with initializer", context);
            }
        }
        if (declaration.getDelegate() != null) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on delegated properties", context);
        }
        if (TypeUtilsKt.canBeNull(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession())) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties of a type with nullable upper bound", context);
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitive(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            if (declaration.isLocal()) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on local variables of primitive types", context);
            } else {
                this.reportError(reporter, declaration.getSource(), "is not allowed on properties of primitive types", context);
            }
        }
        if (DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            this.reportError(reporter, declaration.getSource(), "must be moved to the field declaration", context);
        }
        if ((this.hasGetter(declaration) || this.hasSetter(declaration)) && declaration.getDelegate() == null) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties with a custom getter or setter", context);
        }
        if (FirDeclarationUtilKt.isExtension(declaration)) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on extension properties", context);
        }
        if (!((Collection)declaration.getContextParameters()).isEmpty()) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties with context receivers", context);
        }
        FirMemberDeclaration $this$isAbstract$iv = declaration;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on abstract properties", context);
        }
        if (FirHelpersKt.isSingleFieldValueClass(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession())) {
            ConeKotlinType declarationType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession(), null, 2, null);
            String variables = declaration.isLocal() ? "local variables" : "properties";
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(declarationType)) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on " + variables + " of unsigned types", context);
            } else {
                this.reportError(reporter, declaration.getSource(), "is not allowed on " + variables + " of inline class types", context);
            }
        }
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(DiagnosticReporter $this$reportError, KtSourceElement source, String target, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportError, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), (Object)target, (DiagnosticContext)context, null, 16, null);
    }
}

