/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNonExpansiveInheritanceRestrictionCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0003\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "buildTypeGraph", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$TypeParameterNode;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "TypeParameterNode", "ExpansiveEdge", "Graph", "checkers"})
public final class FirNonExpansiveInheritanceRestrictionChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNonExpansiveInheritanceRestrictionChecker INSTANCE = new FirNonExpansiveInheritanceRestrictionChecker();

    private FirNonExpansiveInheritanceRestrictionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        List containers;
        block11: {
            void $this$mapTo$iv$iv;
            void destination$iv;
            Iterator<FirTypeParameterRef> $this$flatMapTo$iv;
            Object element$iv2;
            void $this$filterTo$iv;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (declaration.getTypeParameters().isEmpty()) {
                return;
            }
            Graph<TypeParameterNode> graph2 = this.buildTypeGraph(declaration, context.getSession());
            Iterable iterable = graph2.getExpansiveEdges();
            Iterable destination$iv2 = SmartSet.Companion.create();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv2 : $this$filterTo$iv) {
                ExpansiveEdge it = (ExpansiveEdge)element$iv2;
                boolean bl2 = false;
                if (!graph2.isEdgeInCycle(it)) continue;
                destination$iv2.add(element$iv2);
            }
            SmartSet edgesInCycles = (SmartSet)destination$iv2;
            if (edgesInCycles.isEmpty()) {
                return;
            }
            destination$iv2 = edgesInCycles;
            Collection $i$f$filterTo22 = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            element$iv2 = $this$flatMapTo$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv3 = element$iv2.next();
                ExpansiveEdge it = (ExpansiveEdge)element$iv3;
                boolean bl3 = false;
                TypeParameterNode[] typeParameterNodeArray = new TypeParameterNode[]{it.getFrom(), it.getTo()};
                Iterable list$iv = CollectionsKt.listOf(typeParameterNodeArray);
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            Set problemNodes = (Set)destination$iv;
            for (FirTypeParameterRef ref : declaration.getTypeParameters()) {
                if (!problemNodes.remove(new TypeParameterNode(declaration.getSymbol(), ref.getSymbol()))) continue;
                KtSourceElement ktSourceElement = ref.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = declaration.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            Iterable $this$map$iv = problemNodes;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeParameterNode typeParameterNode = (TypeParameterNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getContainer());
            }
            containers = (List)destination$iv$iv;
            Iterable $this$any$iv = containers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv3;
                    boolean bl5 = false;
                    if (!(!(it.getOrigin() instanceof FirDeclarationOrigin.Java))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE_IN_JAVA(), (Object)containers, (DiagnosticContext)context, null, 16, null);
    }

    private final Graph<TypeParameterNode> buildTypeGraph(FirRegularClass declaration, FirSession session) {
        Graph<TypeParameterNode> graph2 = new Graph<TypeParameterNode>();
        SmartSet<FirClassifierSymbol<?>> visitedSymbols = SmartSet.Companion.create();
        visitedSymbols.add(declaration.getSymbol());
        FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$visit(session, visitedSymbols, graph2, declaration.getSymbol());
        return graph2;
    }

    private static final void buildTypeGraph$addEdges(Graph<TypeParameterNode> graph2, List<FirTypeParameterSymbol> typeParameters2, Set<? extends ConeKotlinType> constituentTypes, FirRegularClassSymbol symbol, FirRegularClassSymbol constituentTypeSymbol, FirTypeParameterSymbol constituentTypeParameterSymbol, boolean expansive) {
        for (FirTypeParameterSymbol typeParameter : typeParameters2) {
            if (!constituentTypes.contains(FirNestedClassifierScopeKt.toConeType(typeParameter, false)) && !constituentTypes.contains(FirNestedClassifierScopeKt.toConeType(typeParameter, true))) continue;
            graph2.addEdge(new TypeParameterNode(symbol, typeParameter), new TypeParameterNode(constituentTypeSymbol, constituentTypeParameterSymbol), expansive);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildTypeGraph$visit(FirSession $session, SmartSet<FirClassifierSymbol<?>> visitedSymbols, Graph<TypeParameterNode> graph2, FirRegularClassSymbol symbol) {
        void $this$flatMapTo$iv$iv;
        List<FirTypeParameterSymbol> typeParameters2 = symbol.getTypeParameterSymbols();
        if (typeParameters2.isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv = symbol.getResolvedSuperTypes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConeKotlinType it = (ConeKotlinType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (ConeKotlinType constituentType : (List)destination$iv$iv) {
            ConeSubstitutor coneSubstitutor;
            void condition$iv;
            boolean bl;
            List<ConeTypeProjection> arguments2;
            List<FirTypeParameterSymbol> parameters2;
            FirRegularClassSymbol constituentTypeSymbol;
            block15: {
                if (ToSymbolUtilsKt.toRegularClassSymbol(constituentType, $session) == null) continue;
                if (visitedSymbols.add(constituentTypeSymbol)) {
                    FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$visit($session, visitedSymbols, graph2, constituentTypeSymbol);
                }
                parameters2 = constituentTypeSymbol.getTypeParameterSymbols();
                arguments2 = ArraysKt.asList(constituentType.getTypeArguments());
                if (parameters2.size() != arguments2.size()) continue;
                Iterable $this$any$iv = arguments2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeTypeProjection it = (ConeTypeProjection)element$iv;
                        boolean bl2 = false;
                        if (!(it.getKind() != ProjectionKind.INVARIANT)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            boolean $this$any$iv = bl;
            boolean $i$f$runIf = false;
            if (condition$iv != false) {
                boolean bl3 = false;
                coneSubstitutor = FirNonExpansiveInheritanceRestrictionCheckerKt.access$substitutorByType(parameters2, arguments2, $session);
            } else {
                coneSubstitutor = null;
            }
            ConeSubstitutor substitutor2 = coneSubstitutor;
            Iterator iterator2 = ((Iterable)arguments2).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Iterable list$iv;
                ConeKotlinType it;
                Iterable $this$flatMapTo$iv;
                int i = n++;
                ConeTypeProjection typeProjection = (ConeTypeProjection)iterator2.next();
                FirTypeParameterSymbol constituentTypeParameterSymbol = parameters2.get(i);
                if (typeProjection.getKind() == ProjectionKind.INVARIANT) {
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeProjection);
                    Intrinsics.checkNotNull(coneKotlinType);
                    Set constituents = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(coneKotlinType);
                    ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(typeProjection);
                    Intrinsics.checkNotNull(coneKotlinType2);
                    FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$addEdges(graph2, typeParameters2, constituents, symbol, constituentTypeSymbol, constituentTypeParameterSymbol, !(ConeTypeUtilsKt.unwrapLowerBound(coneKotlinType2) instanceof ConeTypeParameterType));
                    continue;
                }
                SmartSet<ConeKotlinType> bounds = SmartSet.Companion.create();
                Iterable $this$mapNotNullTo$iv = constituentTypeParameterSymbol.getResolvedBounds();
                boolean $i$f$mapNotNullTo22 = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    ConeKotlinType it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    FirResolvedTypeRef it2 = (FirResolvedTypeRef)element$iv;
                    boolean bl5 = false;
                    ConeSubstitutor coneSubstitutor2 = substitutor2;
                    Intrinsics.checkNotNull(coneSubstitutor2);
                    if (coneSubstitutor2.substituteOrNull(it2.getConeType()) == null) continue;
                    boolean bl6 = false;
                    ((Collection)bounds).add(it$iv);
                }
                if (ConeTypeProjectionKt.getType(typeProjection) != null) {
                    ConeKotlinType p0;
                    boolean bl7 = false;
                    bounds.add(p0);
                }
                Iterable $i$f$mapNotNullTo22 = bounds;
                Collection destination$iv = SmartSet.Companion.create();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    it = (ConeKotlinType)element$iv;
                    boolean bl8 = false;
                    list$iv = TypeUtilsKt.collectUpperBounds(it);
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                SmartSet boundClosure = (SmartSet)destination$iv;
                $this$flatMapTo$iv = boundClosure;
                destination$iv = SmartSet.Companion.create();
                List<FirTypeParameterSymbol> list = typeParameters2;
                Graph<TypeParameterNode> graph3 = graph2;
                $i$f$flatMapTo2 = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    it = (ConeClassLikeType)element$iv;
                    boolean bl9 = false;
                    list$iv = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(it);
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                Collection collection = destination$iv;
                FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$addEdges(graph3, list, (Set)collection, symbol, constituentTypeSymbol, constituentTypeParameterSymbol, true);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c7\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d7\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0004\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "component1", "()Ljava/lang/Object;", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getFrom", "getTo"})
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public ExpansiveEdge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from, T to) {
            return new ExpansiveEdge<T>(from, to);
        }

        public static /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ')';
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpansiveEdge)) {
                return false;
            }
            ExpansiveEdge expansiveEdge = (ExpansiveEdge)other;
            if (!Intrinsics.areEqual(this.from, expansiveEdge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, expansiveEdge.to);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0005\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R&\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u00138\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u00188\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "<init>", "()V", "from", "to", "", "expansive", "", "addEdge", "(Ljava/lang/Object;Ljava/lang/Object;Z)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "edge", "isEdgeInCycle", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;)Z", "", "collectReachable", "(Ljava/lang/Object;)Ljava/util/List;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "expansiveEdges", "Lorg/jetbrains/kotlin/utils/SmartSet;", "getExpansiveEdges", "()Lorg/jetbrains/kotlin/utils/SmartSet;", "", "", "edgeLists", "Ljava/util/Map;"})
    private static final class Graph<T> {
        @NotNull
        private final SmartSet<ExpansiveEdge<T>> expansiveEdges = SmartSet.Companion.create();
        @NotNull
        private final Map<T, Set<T>> edgeLists = new LinkedHashMap();

        @NotNull
        public final SmartSet<ExpansiveEdge<T>> getExpansiveEdges() {
            return this.expansiveEdges;
        }

        public final void addEdge(T from, T to, boolean expansive) {
            Set set;
            Map<T, Set<T>> $this$getOrPut$iv = this.edgeLists;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(from);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = SmartSet.Companion.create();
                $this$getOrPut$iv.put(from, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<T>(from, to));
            }
        }

        public static /* synthetic */ void addEdge$default(Graph graph2, Object object, Object object2, boolean bl, int n, Object object3) {
            if ((n & 4) != 0) {
                bl = false;
            }
            graph2.addEdge(object, object2, bl);
        }

        public final boolean isEdgeInCycle(@NotNull ExpansiveEdge<? extends T> edge) {
            Intrinsics.checkNotNullParameter(edge, "edge");
            return this.collectReachable(edge.getTo()).contains(edge.getFrom());
        }

        private final List<T> collectReachable(T from) {
            DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

                public void afterChildren(T current) {
                    ((LinkedList)this.result).add(current);
                }
            };
            DFS.Neighbors<Object> neighbors2 = arg_0 -> Graph.collectReachable$lambda$1(this, arg_0);
            DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, handler2);
            Object object = handler2.result();
            Intrinsics.checkNotNullExpressionValue(object, "result(...)");
            return (List)object;
        }

        private static final Iterable collectReachable$lambda$1(Graph this$0, Object current) {
            Set set = this$0.edgeLists.get(current);
            return set != null ? (Iterable)set : (Iterable)SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$TypeParameterNode;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "container", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "typeParameter", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;)V", "component1", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "component2", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "copy", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$TypeParameterNode;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getContainer", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameter"})
    private static final class TypeParameterNode {
        @NotNull
        private final FirRegularClassSymbol container;
        @NotNull
        private final FirTypeParameterSymbol typeParameter;

        public TypeParameterNode(@NotNull FirRegularClassSymbol container, @NotNull FirTypeParameterSymbol typeParameter) {
            Intrinsics.checkNotNullParameter(container, "container");
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            this.container = container;
            this.typeParameter = typeParameter;
        }

        @NotNull
        public final FirRegularClassSymbol getContainer() {
            return this.container;
        }

        @NotNull
        public final FirTypeParameterSymbol getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final FirRegularClassSymbol component1() {
            return this.container;
        }

        @NotNull
        public final FirTypeParameterSymbol component2() {
            return this.typeParameter;
        }

        @NotNull
        public final TypeParameterNode copy(@NotNull FirRegularClassSymbol container, @NotNull FirTypeParameterSymbol typeParameter) {
            Intrinsics.checkNotNullParameter(container, "container");
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            return new TypeParameterNode(container, typeParameter);
        }

        public static /* synthetic */ TypeParameterNode copy$default(TypeParameterNode typeParameterNode, FirRegularClassSymbol firRegularClassSymbol, FirTypeParameterSymbol firTypeParameterSymbol, int n, Object object) {
            if ((n & 1) != 0) {
                firRegularClassSymbol = typeParameterNode.container;
            }
            if ((n & 2) != 0) {
                firTypeParameterSymbol = typeParameterNode.typeParameter;
            }
            return typeParameterNode.copy(firRegularClassSymbol, firTypeParameterSymbol);
        }

        @NotNull
        public String toString() {
            return "TypeParameterNode(container=" + this.container + ", typeParameter=" + this.typeParameter + ')';
        }

        public int hashCode() {
            int result2 = this.container.hashCode();
            result2 = result2 * 31 + this.typeParameter.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeParameterNode)) {
                return false;
            }
            TypeParameterNode typeParameterNode = (TypeParameterNode)other;
            if (!Intrinsics.areEqual(this.container, typeParameterNode.container)) {
                return false;
            }
            return Intrinsics.areEqual(this.typeParameter, typeParameterNode.typeParameter);
        }
    }
}

