/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "objectRefVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "Data", "checkers"})
public final class FirObjectConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirObjectConstructorChecker INSTANCE = new FirObjectConstructorChecker();
    @NotNull
    private static final FirVisitor<Unit, Data> objectRefVisitor = new FirVisitor<Unit, Data>(){

        public void visitElement(FirElement element, Data data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
            element.acceptChildren(this, data2);
        }

        public void visitThisReceiverExpression(FirThisReceiverExpression thisReceiverExpression, Data data2) {
            Intrinsics.checkNotNullParameter(thisReceiverExpression, "thisReceiverExpression");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (Intrinsics.areEqual(thisReceiverExpression.getCalleeReference().getBoundSymbol(), data2.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)thisReceiverExpression.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
            }
        }

        public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier, Data data2) {
            Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (Intrinsics.areEqual(resolvedQualifier.getSymbol(), data2.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
            } else if (resolvedQualifier.getResolvedToCompanionObject()) {
                FirRegularClassSymbol companionSymbol;
                FirRegularClassSymbol firRegularClassSymbol = resolvedQualifier.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, data2.getContext().getSession())) != null ? firRegularClassSymbol.getCompanionObjectSymbol() : (companionSymbol = null);
                if (Intrinsics.areEqual(companionSymbol, data2.getObjectSymbol())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
                }
            }
        }

        public void visitAnonymousObjectExpression(FirAnonymousObjectExpression anonymousObjectExpression, Data data2) {
            Intrinsics.checkNotNullParameter(anonymousObjectExpression, "anonymousObjectExpression");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        public void visitGetClassCall(FirGetClassCall getClassCall, Data data2) {
            Intrinsics.checkNotNullParameter(getClassCall, "getClassCall");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess, Data data2) {
            Intrinsics.checkNotNullParameter(callableReferenceAccess, "callableReferenceAccess");
            Intrinsics.checkNotNullParameter(data2, "data");
        }
    };

    private FirObjectConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block3: {
            FirDelegatedConstructorCall firDelegatedConstructorCall;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitSelfCallsInNestedObjects)) {
                return;
            }
            if (declaration.getClassKind() != ClassKind.OBJECT) {
                return;
            }
            FirRegularClassSymbol objectSymbol = declaration.getSymbol();
            if (!Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(objectSymbol), SupertypeUtilsKt.getSuperClassSymbolOrAny(objectSymbol, context.getSession()))) {
                return;
            }
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorSymbol(objectSymbol, context.getSession());
            if (firConstructorSymbol == null || (firDelegatedConstructorCall = firConstructorSymbol.getResolvedDelegatedConstructorCall()) == null) break block3;
            firDelegatedConstructorCall.accept(objectRefVisitor, new Data(objectSymbol, context, reporter));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "objectSymbol", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getObjectSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;"})
    private static final class Data {
        @NotNull
        private final FirRegularClassSymbol objectSymbol;
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public Data(@NotNull FirRegularClassSymbol objectSymbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(objectSymbol, "objectSymbol");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            this.objectSymbol = objectSymbol;
            this.context = context;
            this.reporter = reporter;
        }

        @NotNull
        public final FirRegularClassSymbol getObjectSymbol() {
            return this.objectSymbol;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }
    }
}

