/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0002MNB\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u0013\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u00162\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J1\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u001b0\u00192\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ1\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u001b0\u00192\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ'\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J+\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u00020#2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001fH\u0002\u00a2\u0006\u0004\b$\u0010%JA\u0010'\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b'\u0010(JA\u0010+\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,J'\u0010.\u001a\u00020\f*\u0006\u0012\u0002\b\u00030-2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b.\u0010/JA\u00101\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0010\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001f2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b1\u00102JC\u00106\u001a\u00020\f2\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00105\u001a\u0002042\u0006\u0010*\u001a\u00020)2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b6\u00107J=\u00109\u001a\u00020\f2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0010\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b9\u0010:J/\u0010;\u001a\u00020\f*\u00020\n2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010*\u001a\u00020)2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b;\u0010<J3\u0010?\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b?\u0010@J3\u0010A\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bA\u0010@J3\u0010B\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bB\u0010@J3\u0010C\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bC\u0010@J3\u0010D\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bD\u0010@J3\u0010E\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bE\u0010@J3\u0010F\u001a\u00020\f*\u00020\n2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bF\u0010@R\u001c\u0010I\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0018\u0010L\u001a\u00020\u0012*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u0082\u0001\u0002OP"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "mppKind", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "", "ensureKnownVisibility", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "symbol", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "chooseCannotInferVisibilityFor", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/name/Name;", "chooseCannotChangeAccessPrivilegeFor", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "chooseCannotWeakenAccessPrivilegeFor", "", "overriddenSymbols", "checkModality", "(Ljava/util/List;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkMutability", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "checkVisibility", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "firTypeScope", "checkDeprecation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkDefaultValues", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "overriddenMemberSymbols", "checkDataClassCopy", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "member", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "typeCheckerState", "checkMember", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "memberSymbol", "checkOverriddenExperimentalities", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/List;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "reportNothingToOverride", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "overriding", "overridden", "reportOverridingFinalMember", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportVarOverriddenByVal", "reportCannotWeakenAccessPrivilege", "reportCannotChangeAccessPrivilege", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "getWouldMissDiagnosticInK1", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "wouldMissDiagnosticInK1", "getCanDelegateVisibilityConsistencyChecksToAccessors", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "canDelegateVisibilityConsistencyChecksToAccessors", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;"})
public abstract class FirOverrideChecker
extends FirAbstractOverrideChecker {
    private FirOverrideChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(false, false, context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowDnnTypeOverridingFlexibleType));
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context);
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, new Function1<FirCallableSymbol<?>, Unit>(declaration, this, reporter, typeCheckerState, firTypeScope, context){
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                this.$context = $context;
                super(1, Intrinsics.Kotlin.class, "checkMember", "check$checkMember(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", 0);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                FirOverrideChecker.access$check$checkMember(this.$declaration, this.this$0, this.$reporter, this.$typeCheckerState, this.$firTypeScope, this.$context, p0);
            }
        });
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, new Function1<FirCallableSymbol<?>, Unit>(declaration, this, reporter, typeCheckerState, firTypeScope, context){
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                this.$context = $context;
                super(1, Intrinsics.Kotlin.class, "checkMember", "check$checkMember(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", 0);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                FirOverrideChecker.access$check$checkMember(this.$declaration, this.this$0, this.$reporter, this.$typeCheckerState, this.$firTypeScope, this.$context, p0);
            }
        });
    }

    private final boolean ensureKnownVisibility(FirCallableSymbol<?> $this$ensureKnownVisibility, CheckerContext context, DiagnosticReporter reporter, KtSourceElement source) {
        boolean bl;
        FirCallableSymbol<?> $this$visibility$iv = $this$ensureKnownVisibility;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Unknown.INSTANCE)) {
            bl = true;
        } else {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, this.chooseCannotInferVisibilityFor($this$ensureKnownVisibility), $this$ensureKnownVisibility, (DiagnosticContext)context, null, 16, null);
            bl = bl2;
        }
        return bl;
    }

    static /* synthetic */ boolean ensureKnownVisibility$default(FirOverrideChecker firOverrideChecker, FirCallableSymbol firCallableSymbol, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureKnownVisibility");
        }
        if ((n & 4) != 0) {
            ktSourceElement = firCallableSymbol.getSource();
        }
        return firOverrideChecker.ensureKnownVisibility(firCallableSymbol, checkerContext, diagnosticReporter, ktSourceElement);
    }

    private final KtDiagnosticFactory1<FirCallableSymbol<?>> chooseCannotInferVisibilityFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY() : FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotChangeAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotWeakenAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE_WARNING();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getWouldMissDiagnosticInK1(FirCallableSymbol<?> $this$wouldMissDiagnosticInK1) {
        if (!($this$wouldMissDiagnosticInK1 instanceof FirPropertyAccessorSymbol)) return false;
        if (!ClassMembersKt.isIntersectionOverride(((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol())) return false;
        FirCallableSymbol $this$visibility$iv = $this$wouldMissDiagnosticInK1;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        $this$visibility$iv = ((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol();
        $i$f$getVisibility = false;
        if (Intrinsics.areEqual(visibility, $this$visibility$iv.getResolvedStatus().getVisibility())) return false;
        return true;
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols, CheckerContext context) {
        boolean hasVisibleBase;
        block14: {
            boolean bl;
            block16: {
                List<Pair> visibilities;
                block15: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    DiagnosticReporter diagnosticReporter;
                    Iterator<Pair> $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (!FirOverrideChecker.ensureKnownVisibility$default(this, $this$checkVisibility, context, reporter, null, 4, null)) {
                        return;
                    }
                    if (overriddenSymbols.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to(it, $this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy22 = false;
                    visibilities = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a, T b) {
                            Pair pair = (Pair)a;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b;
                            Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues(comparable, n2 != null ? n2 : Integer.MIN_VALUE);
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol) || !this.getCanDelegateVisibilityConsistencyChecksToAccessors((FirPropertySymbol)$this$checkVisibility)) break block15;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy22 = overriddenSymbols;
                        diagnosticReporter = reporter;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                    }
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                    if (firPropertyAccessorSymbol3 == null) break block16;
                    Iterable $this$map$iv2 = overriddenSymbols;
                    diagnosticReporter = reporter;
                    firClass = containingClass;
                    firCallableSymbol = firPropertyAccessorSymbol3;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                    break block16;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare == null) {
                        this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, overridden, context);
                        break;
                    }
                    if (compare >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, overridden, context);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFile firFile = context.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List<FirClass> containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
            Iterable $this$any$iv = overriddenSymbols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context.getSession(), file2, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                    bl = true;
                    break block14;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final boolean getCanDelegateVisibilityConsistencyChecksToAccessors(FirPropertySymbol $this$canDelegateVisibilityConsistencyChecksToAccessors) {
        return $this$canDelegateVisibilityConsistencyChecksToAccessors.getGetterSymbol() != null || $this$canDelegateVisibilityConsistencyChecksToAccessors.getSetterSymbol() != null;
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols, CheckerContext context, FirTypeScope firTypeScope) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(context.getLanguageVersionSettings());
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            FirDeprecationInfo firDeprecationInfo;
            if (overriddenSymbol.getDeprecation(context.getLanguageVersionSettings()) == null || (firDeprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (FirDeprecationInfo)CollectionsKt.firstOrNull((Iterable)object) : (firDeprecationInfo = null)) == null) continue;
            FirDeprecationInfo deprecationFromOverriddenSymbol = firDeprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        if ($this$checkDeprecation instanceof FirNamedFunctionSymbol) {
            String string2 = ((FirNamedFunctionSymbol)$this$checkDeprecation).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String callableName = string2;
            if (FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenReplacements$checkers().containsKey(callableName)) {
                FirTypeScopeKt.processOverriddenFunctions(firTypeScope, (FirNamedFunctionSymbol)$this$checkDeprecation, arg_0 -> FirOverrideChecker.checkDeprecation$lambda$8(callableName, reporter, $this$checkDeprecation, context, arg_0));
            }
        }
    }

    private final void checkDefaultValues(FirFunctionSymbol<?> $this$checkDefaultValues, DiagnosticReporter reporter, CheckerContext context) {
        for (FirValueParameterSymbol valueParameterSymbol : $this$checkDefaultValues.getValueParameterSymbols()) {
            if (!valueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameterSymbol.getDefaultValueSource(), FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkDataClassCopy(FirCallableSymbol<?> $this$checkDataClassCopy, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass, CheckerContext context) {
        FirCallableSymbol<?> firCallableSymbol = CollectionsKt.firstOrNull(overriddenMemberSymbols);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> overridden = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)overridden);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol overriddenClass = firClassSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), $this$checkDataClassCopy, (Object)overriddenClass, (DiagnosticContext)context, null, 32, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMember(FirCallableSymbol<?> member, FirClass containingClass, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        block40: {
            block42: {
                block41: {
                    block38: {
                        overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, member);
                        v0 = member;
                        v1 = KtTokens.OVERRIDE_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(v1, "OVERRIDE_KEYWORD");
                        hasOverrideKeyword = FirKeywordUtilsKt.hasModifier(v0, v1);
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        v2 = isOverride = $this$isOverride$iv.getRawStatus().isOverride() != false && (Intrinsics.areEqual(member.getOrigin(), FirDeclarationOrigin.Source.INSTANCE) == false || hasOverrideKeyword != false);
                        if (isOverride) break block40;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                            return;
                        }
                        v3 = member.getSource();
                        v4 = kind = v3 != null ? v3.getKind() : null;
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v5 = context.getContainingFile();
                        if (v5 == null) {
                            return;
                        }
                        file = v5;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        var18_26 = $this$firstOrNull$iv.iterator();
                        while (var18_26.hasNext()) {
                            element$iv = var18_26.next();
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                            var22_34 = it;
                            var23_35 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                                // 2 sources

                                {
                                    v6 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v6 = v7 = null;
                                }
                                if (v6 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v7 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v7 == null) break;
                                result$iv$iv = v7;
                            }
                            v8 = result$iv$iv.getSymbol();
                            if (v8 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityChecker.isVisible$default(var23_35, (FirMemberDeclaration)v8.getFir(), context.getSession(), file, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                            v9 = element$iv;
                            break block38;
                        }
                        v9 = null;
                    }
                    var15_51 = v9;
                    if (var15_51 == null) break block41;
                    $i$f$firstOrNull = var15_51;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                        // 2 sources

                        {
                            v10 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v10 = v11 = null;
                        }
                        if (v10 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v11 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v11 == null) break;
                        result$iv$iv = v11;
                    }
                    v12 = result$iv$iv.getSymbol();
                    if (v12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    $this$firstOrNull$iv = v12;
                    if ($this$firstOrNull$iv != null) break block42;
                }
                return;
            }
            overridden = $this$firstOrNull$iv;
            v13 = ClassMembersKt.containingClassLookupTag(overridden);
            if (v13 == null || (v13 = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)v13, context.getSession())) == null) {
                return;
            }
            originalContainingClassSymbol = v13;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, originalContainingClassSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        v14 = member.getSource();
        if ((v14 != null ? v14.getKind() : null) instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
            block39: {
                file = overriddenMemberSymbols;
                for (T var14_54 : file) {
                    it = (FirCallableSymbol)var14_54;
                    $i$a$-find-FirOverrideChecker$checkMember$1 = false;
                    $this$isFinal$iv = it;
                    $i$f$isFinal = false;
                    v15 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
                    if (!v15) continue;
                    v16 = var14_54;
                    break block39;
                }
                v16 = null;
            }
            v17 = v16;
            if (v17 != null) {
                base = v17;
                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member, (Object)base, (DiagnosticContext)context, null, 32, null);
            }
            if (Intrinsics.areEqual(member.getName(), StandardNames.DATA_CLASS_COPY)) {
                this.checkDataClassCopy(member, reporter, overriddenMemberSymbols, containingClass, context);
            }
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, member, firTypeScope, context);
            return;
        }
        this.checkOverriddenExperimentalities(member, overriddenMemberSymbols, context, reporter);
        if (!ClassMembersKt.isIntersectionOverride(member) && !ClassMembersKt.isDelegated(member)) {
            v18 = this.checkModality(overriddenMemberSymbols);
            if (v18 != null) {
                it = v18;
                $i$a$-let-FirOverrideChecker$checkMember$3 = false;
                this.reportOverridingFinalMember(reporter, member, it, context);
            }
        }
        if (member instanceof FirPropertySymbol && !ClassMembersKt.isDelegated(member)) {
            v19 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v19 != null) {
                it = v19;
                $i$a$-let-FirOverrideChecker$checkMember$4 = false;
                this.reportVarOverriddenByVal(reporter, member, it, context);
            }
        }
        this.checkVisibility(member, containingClass, reporter, overriddenMemberSymbols, context);
        if (Intrinsics.areEqual(member.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            this.checkDeprecation(member, reporter, overriddenMemberSymbols, context, firTypeScope);
        }
        if (member instanceof FirFunctionSymbol && !Intrinsics.areEqual(((FirFunctionSymbol)member).getOrigin(), FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE)) {
            this.checkDefaultValues((FirFunctionSymbol)member, reporter, context);
        }
        if (ClassMembersKt.isIntersectionOverride(member) || ClassMembersKt.isDelegated(member)) {
            return;
        }
        v20 = this.checkReturnType(member, overriddenMemberSymbols, typeCheckerState, context);
        if (v20 == null) {
            return;
        }
        restriction = v20;
        var11_12 = member;
        if (var11_12 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter, member, restriction, context);
        } else if (var11_12 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(reporter, member, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter, member, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context, DiagnosticReporter reporter) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2415 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session = context.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf(it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2415.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2415.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context, reporter);
    }

    /*
     * Unable to fully structure code
     */
    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, FirTypeScope firTypeScope, CheckerContext context) {
        containingClassSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)declaration);
        var7_6 = declaration instanceof FirPropertySymbol != false ? FirScopeKt.getProperties(firTypeScope, ((FirPropertySymbol)declaration).getName()) : FirScopeKt.getFunctions(firTypeScope, declaration.getName());
        $i$f$filter = false;
        var9_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirCallableSymbol)element$iv$iv;
            $i$a$-filter-FirOverrideChecker$reportNothingToOverride$candidates$1 = false;
            $this$unwrapFakeOverrides$iv = it;
            $i$f$unwrapFakeOverrides = false;
            $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
            $i$f$unwrapFakeOverrides = false;
            current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
            while (true) {
                $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                $i$f$originalIfFakeOverride = false;
                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                } else {
                    v0 = v1 = null;
                }
                if (v0 == null) {
                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    $i$f$getBaseForIntersectionOverride = false;
                    v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                }
                if (v1 == null) break;
                current$iv$iv = next$iv$iv = v1;
            }
            v2 = current$iv$iv.getSymbol();
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            if (Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)v2), containingClassSymbol)) ** GOTO lbl-1000
            $this$isOpen$iv = it;
            $i$f$isOpen = false;
            if ($this$isOpen$iv.getResolvedStatus().getModality() == Modality.OPEN) ** GOTO lbl-1000
            $this$isAbstract$iv = it;
            $i$f$isAbstract = false;
            if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidates = (List)destination$iv$iv;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportNothingToOverride, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, (Object)candidates, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overridden, overriding, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotWeakenAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotChangeAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private static final void check$checkMember(FirClass $declaration, FirOverrideChecker this$0, DiagnosticReporter $reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext $context, FirCallableSymbol<?> it) {
        block3: {
            KtSourceElement ktSourceElement;
            block5: {
                block4: {
                    KtSourceElement ktSourceElement2;
                    boolean isFromThis;
                    block2: {
                        isFromThis = Intrinsics.areEqual(ClassMembersKt.containingClassLookupTag(it), $declaration.getSymbol().toLookupTag());
                        if (!isFromThis || ClassMembersKt.isSubstitutionOverride(it)) break block2;
                        this$0.checkMember(it, $declaration, $reporter, typeCheckerState, firTypeScope, $context);
                        break block3;
                    }
                    ktSourceElement = it.getSource();
                    if (ktSourceElement == null) break block4;
                    KtSourceElement it2 = ktSourceElement2 = ktSourceElement;
                    boolean bl = false;
                    ktSourceElement = isFromThis ? ktSourceElement2 : null;
                    if (ktSourceElement != null) break block5;
                }
                ktSourceElement = $declaration.getSource();
            }
            KtSourceElement source = ktSourceElement;
            this$0.ensureKnownVisibility(it, $context, $reporter, source);
        }
    }

    private static final ProcessorAction checkDeprecation$lambda$8(String $callableName, DiagnosticReporter $reporter, FirCallableSymbol $this_checkDeprecation, CheckerContext $context, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (DeprecationUtilsKt.hiddenStatusOfCall(it, false, true) == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
            String message = FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenMessage$checkers($callableName);
            FirDeprecationInfo deprecationInfo2 = new FirDeprecationInfo(message){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                }

                public DeprecationLevelValue getDeprecationLevel() {
                    return DeprecationLevelValue.WARNING;
                }

                public boolean getPropagatesToOverrides() {
                    return false;
                }

                public String getMessage(FirSession session) {
                    Intrinsics.checkNotNullParameter(session, "session");
                    return this.$message;
                }
            };
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirNamedFunctionSymbol)$this_checkDeprecation).getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), (Object)it, (Object)deprecationInfo2, (DiagnosticContext)$context, null, 32, null);
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public /* synthetic */ FirOverrideChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final /* synthetic */ void access$check$checkMember(FirClass $declaration, FirOverrideChecker this$0, DiagnosticReporter $reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext $context, FirCallableSymbol it) {
        FirOverrideChecker.check$checkMember($declaration, this$0, $reporter, typeCheckerState, firTypeScope, $context, it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class ForExpectClass
    extends FirOverrideChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class Regular
    extends FirOverrideChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }
}

