/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSmartCastExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDeprecatedSmartCastChecker
extends FirExpressionChecker<FirSmartCastExpression> {
    @NotNull
    public static final FirDeprecatedSmartCastChecker INSTANCE = new FirDeprecatedSmartCastChecker();

    private FirDeprecatedSmartCastChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirSmartCastExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object object;
        KtSourceElement source;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(expression, "expression");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.UnstableSmartcastOnDelegatedProperties)) {
                    return;
                }
                if (!expression.isStable()) {
                    return;
                }
                KtSourceElement ktSourceElement = expression.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                object = ReferenceUtilsKt.toReference(expression.getOriginalExpression(), context.getSession());
                if (object == null) break block8;
                FirReference $this$toResolvedSymbol_u24default$iv = object;
                boolean discardErrorReference$iv = false;
                boolean $i$f$toResolvedSymbol = false;
                FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
                FirBasedSymbol<Object> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
                if (!(firBasedSymbol instanceof FirPropertySymbol)) {
                    firBasedSymbol = null;
                }
                if ((object = (FirPropertySymbol)((FirBasedSymbol)((FirPropertySymbol)firBasedSymbol))) != null) break block9;
            }
            return;
        }
        Object symbol = object;
        if (ClassMembersKt.isDelegated((FirCallableSymbol)symbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SMARTCAST_ON_DELEGATED_PROPERTY(), (Object)FirTypeUtilsKt.getResolvedType(expression), symbol, (DiagnosticContext)context, null, 32, null);
        }
    }
}

