/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000\u00f2\u0001\u0004\n\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isNamedSpread", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "checkers"})
public final class FirNamedVarargChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirNamedVarargChecker INSTANCE = new FirNamedVarargChecker();

    private FirNamedVarargChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(expression instanceof FirFunctionCall || expression instanceof FirAnnotation || expression instanceof FirDelegatedConstructorCall || expression instanceof FirArrayLiteral)) {
            return;
        }
        boolean isAnnotation = expression instanceof FirAnnotation;
        KtDiagnosticFactory0 redundantSpreadWarningFactory = isAnnotation ? FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION() : FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION();
        boolean allowAssignArray = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(isAnnotation ? LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations : LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions);
        if (expression instanceof FirArrayLiteral) {
            void $this$forEach$iv;
            Object $this$arguments$iv = expression;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                FirNamedVarargChecker.check$checkArgument(expression, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, it, INSTANCE.isNamedSpread(it), FirTypeUtilsKt.getResolvedType((FirExpression)((Object)expression)));
            }
        } else {
            FirCall $this$resolvedArgumentMapping$iv = expression;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMap = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMap).entrySet()) {
                FirExpression argument = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                if (!parameter.isVararg()) continue;
                if (argument instanceof FirVarargArgumentsExpression) {
                    Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)argument).getArguments();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl = false;
                        FirNamedVarargChecker.check$checkArgument(expression, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, it, true, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()));
                    }
                    continue;
                }
                FirNamedVarargChecker.check$checkArgument(expression, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, argument, false, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()));
            }
        }
    }

    private final boolean isNamedSpread(FirExpression expression) {
        return expression instanceof FirSpreadArgumentExpression && ((FirSpreadArgumentExpression)expression).isNamed();
    }

    private static final void check$checkArgument(FirCall $expression, DiagnosticReporter $reporter, KtDiagnosticFactory0 redundantSpreadWarningFactory, CheckerContext $context, boolean allowAssignArray, boolean isAnnotation, FirExpression argument, boolean isVararg, ConeKotlinType expectedArrayType) {
        if (!INSTANCE.isNamedSpread(argument)) {
            return;
        }
        if (!((FirSpreadArgumentExpression)argument).isFakeSpread() && ((FirSpreadArgumentExpression)argument).isNamed()) {
            if (isVararg) {
                FirResolvable firResolvable = $expression instanceof FirResolvable ? (FirResolvable)((Object)$expression) : null;
                if (!((firResolvable != null ? firResolvable.getCalleeReference() : null) instanceof FirResolvedErrorReference)) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument).getExpression().getSource(), redundantSpreadWarningFactory, (DiagnosticContext)$context, null, 8, null);
                }
            }
            return;
        }
        ConeRigidType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(((FirSpreadArgumentExpression)argument).getExpression()), $context.getSession(), null, 2, null));
        if (type2 instanceof ConeErrorType) {
            return;
        }
        if (((FirSpreadArgumentExpression)argument).getExpression() instanceof FirArrayLiteral) {
            return;
        }
        if (allowAssignArray && ConeBuiltinTypeUtilsKt.isArrayType(type2)) {
            return;
        }
        if (isAnnotation) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION(), (DiagnosticContext)$context, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION(), (Object)expectedArrayType, (DiagnosticContext)$context, null, 16, null);
        }
    }
}

