/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInAnnotationCallChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.EnumValueArgumentInfo;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.checkers.OptInDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInInheritanceDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.OptInUsagesDiagnosticMessageProvider;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001`B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u0010\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J1\u0010\u0010\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0015J+\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u0007\u00a2\u0006\u0004\b\u001f\u0010\u001dJ7\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u001b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0004\b#\u0010$J%\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u001b*\u0006\u0012\u0002\b\u00030%2\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030%2\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b(\u0010)J]\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u001b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0017\u001a\u00020\u00162\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010 \u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b#\u0010.JU\u00102\u001a\u00020\u000f*\u00020/2\n\u00101\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010 \u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010!2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0*H\u0002\u00a2\u0006\u0004\b2\u00103JC\u00105\u001a\u00020\u000f*\u0002042\n\u00101\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0*H\u0002\u00a2\u0006\u0004\b5\u00106J;\u00107\u001a\u00020\u000f*\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0*2\u000e\b\u0002\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,H\u0002\u00a2\u0006\u0004\b7\u00108J)\u0010\n\u001a\u0004\u0018\u00010\t*\u0002092\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010:J?\u0010C\u001a\u00020\u000f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\t0;2\u0006\u0010>\u001a\u00020=2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010@\u001a\u00020?2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010A\u00a2\u0006\u0004\bC\u0010DJ7\u0010E\u001a\u00020\u000f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\t0;2\n\u00101\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010@\u001a\u00020?\u00a2\u0006\u0004\bE\u0010FJ\u001d\u0010J\u001a\u0004\u0018\u00010A*\u00020G2\u0006\u0010I\u001a\u00020HH\u0007\u00a2\u0006\u0004\bJ\u0010KJ'\u0010N\u001a\u00020\u00132\u0006\u0010M\u001a\u00020L2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\bN\u0010OJ+\u0010Q\u001a\u00020\u0013*\u00020P2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010M\u001a\u00020L2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\bQ\u0010RJ\u0013\u0010S\u001a\u00020\u0013*\u00020PH\u0002\u00a2\u0006\u0004\bS\u0010TJ#\u0010U\u001a\u00020\u0013*\u00020P2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010M\u001a\u00020LH\u0002\u00a2\u0006\u0004\bU\u0010VJ#\u0010W\u001a\u00020\u0013*\u00020P2\u0006\u0010M\u001a\u00020L2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\bW\u0010XJ#\u0010Y\u001a\u00020\u0013*\u00020P2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010M\u001a\u00020LH\u0002\u00a2\u0006\u0004\bY\u0010VJ\u001b\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010A0\u0018*\u00020GH\u0002\u00a2\u0006\u0004\bZ\u0010[R\u0014\u0010]\u001a\u00020\\8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0014\u0010_\u001a\u00020\\8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010^"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "annotatedOwnerClassName", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "loadExperimentalityForMarkerAnnotation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "result", "", "loadExperimentalitiesFromAnnotationTo", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Collection;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "fromSupertype", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Collection;Z)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "typeArguments", "", "loadExperimentalitiesFromTypeArguments", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "loadExperimentalitiesFromConeArguments", "fromSetter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "dispatchReceiverType", "loadExperimentalities", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "loadExperimentalitiesFromSupertype", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Ljava/util/Set;", "isExperimentalMarker", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/utils/SmartSet;", "knownExperimentalities", "", "visited", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/utils/SmartSet;Ljava/util/Set;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "loadCallableSpecificExperimentalities", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/Set;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/utils/SmartSet;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "loadClassLikeSpecificExperimentalities", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/Set;Lorg/jetbrains/kotlin/utils/SmartSet;)V", "addExperimentalities", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/utils/SmartSet;Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "experimentalities", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "reportNotAcceptedExperimentalities", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "reportNotAcceptedOverrideExperimentalities", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "", "argumentIndex", "getSourceForIsMarkerDiagnostic", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;I)Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationClassId", "isExperimentalityAcceptableInContext", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Z)Z", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isExperimentalityAcceptable", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;Z)Z", "isImplicitDeclaration", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;)Z", "primaryConstructorParameterIsExperimentalityAcceptable", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;)Z", "isAnnotatedWithOptIn", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "isAnnotatedWithSubclassOptInRequired", "getMarkerArgumentsSources", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Ljava/util/List;", "Lorg/jetbrains/kotlin/name/Name;", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "Experimentality"})
public final class FirOptInUsageBaseChecker {
    @NotNull
    public static final FirOptInUsageBaseChecker INSTANCE = new FirOptInUsageBaseChecker();
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;

    private FirOptInUsageBaseChecker() {
    }

    @Nullable
    public final Experimentality loadExperimentalityForMarkerAnnotation(@NotNull FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation, @NotNull FirSession session, @Nullable String annotatedOwnerClassName) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalityForMarkerAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalityForMarkerAnnotation, FirResolvePhase.BODY_RESOLVE);
        return this.loadExperimentalityForMarkerAnnotation((FirRegularClass)$this$loadExperimentalityForMarkerAnnotation.getFir(), session, annotatedOwnerClassName);
    }

    public static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClassSymbol firRegularClassSymbol, FirSession firSession, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClassSymbol, firSession, string2);
    }

    public final void loadExperimentalitiesFromAnnotationTo(@NotNull FirBasedSymbol<?> $this$loadExperimentalitiesFromAnnotationTo, @NotNull FirSession session, @NotNull Collection<Experimentality> result2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromAnnotationTo, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(result2, "result");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalitiesFromAnnotationTo, FirResolvePhase.STATUS);
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)$this$loadExperimentalitiesFromAnnotationTo.getFir(), session, result2, false);
    }

    private final void loadExperimentalitiesFromAnnotationTo(FirDeclaration $this$loadExperimentalitiesFromAnnotationTo, FirSession session, Collection<Experimentality> result2, boolean fromSupertype) {
        for (FirAnnotation annotation : $this$loadExperimentalitiesFromAnnotationTo.getAnnotations()) {
            FirExpression annotationClass;
            Object object;
            ConeClassLikeType annotationType;
            Object object2 = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
            if ((object2 instanceof ConeClassLikeType ? (ConeClassLikeType)object2 : null) == null) continue;
            annotationType = annotationType;
            object2 = $this$loadExperimentalitiesFromAnnotationTo;
            String className = object2 instanceof FirRegularClass ? ((FirRegularClass)$this$loadExperimentalitiesFromAnnotationTo).getName().asString() : (object2 instanceof FirCallableDeclaration ? ((object = ((FirCallableDeclaration)$this$loadExperimentalitiesFromAnnotationTo).getSymbol().getCallableId().getClassName()) != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null) : null);
            object2 = ToSymbolUtilsKt.toRegularClassSymbol(annotationType.getLookupTag(), session);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, object2 != null ? this.loadExperimentalityForMarkerAnnotation((FirRegularClassSymbol)object2, session, className) : null);
            if (!fromSupertype || !Intrinsics.areEqual(annotationType.getLookupTag().getClassId(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
            List<FirRegularClassSymbol> classes2 = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClass, session);
            Iterable $this$forEach$iv = classes2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol klass = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                Experimentality experimentality = FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(INSTANCE, klass, session, null, 2, null);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, experimentality != null ? Experimentality.copy$default(experimentality, null, null, null, null, true, 15, null) : null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromTypeArguments(@NotNull CheckerContext context, @NotNull List<? extends FirTypeProjection> typeArguments) {
        Collection<ConeTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = typeArguments;
        CheckerContext checkerContext = context;
        FirOptInUsageBaseChecker firOptInUsageBaseChecker = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
        }
        collection = (List)destination$iv$iv;
        return firOptInUsageBaseChecker.loadExperimentalitiesFromConeArguments(checkerContext, (List<? extends ConeTypeProjection>)collection);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConeArguments(@NotNull CheckerContext context, @NotNull List<? extends ConeTypeProjection> typeArguments) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartSet result2 = SmartSet.Companion.create();
        Iterable $this$forEach$iv = typeArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeTypeProjection it = (ConeTypeProjection)element$iv;
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            FirOptInUsageBaseChecker.addExperimentalities$default(INSTANCE, coneKotlinType, context, result2, null, 4, null);
        }
        return result2;
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalities(@NotNull FirBasedSymbol<?> $this$loadExperimentalities, @NotNull CheckerContext context, boolean fromSetter, @Nullable ConeKotlinType dispatchReceiverType) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalities, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.loadExperimentalities($this$loadExperimentalities, context, null, new LinkedHashSet(), fromSetter, dispatchReceiverType, false);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromSupertype(@NotNull FirClassLikeSymbol<?> $this$loadExperimentalitiesFromSupertype, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromSupertype, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.loadExperimentalities((FirBasedSymbol)$this$loadExperimentalitiesFromSupertype, context, null, new LinkedHashSet(), false, null, true);
    }

    public final boolean isExperimentalMarker(@NotNull FirClassLikeSymbol<?> $this$isExperimentalMarker, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isExperimentalMarker, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return $this$isExperimentalMarker instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$isExperimentalMarker, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session) != null;
    }

    private final Set<Experimentality> loadExperimentalities(FirBasedSymbol<?> $this$loadExperimentalities, CheckerContext context, SmartSet<Experimentality> knownExperimentalities, Set<FirDeclaration> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, boolean fromSupertype) {
        FirSinceKotlinAccessibility accessibility;
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalities, FirResolvePhase.STATUS);
        Object fir = $this$loadExperimentalities.getFir();
        if (!visited2.add((FirDeclaration)fir)) {
            return SetsKt.emptySet();
        }
        SmartSet<Experimentality> smartSet = knownExperimentalities;
        if (smartSet == null) {
            smartSet = SmartSet.Companion.create();
        }
        SmartSet<Experimentality> result2 = smartSet;
        FirSession session = context.getSession();
        Object obj = fir;
        if (obj instanceof FirCallableDeclaration) {
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)fir;
            Intrinsics.checkNotNull($this$loadExperimentalities, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            this.loadCallableSpecificExperimentalities(firCallableDeclaration, (FirCallableSymbol)$this$loadExperimentalities, context, visited2, fromSetter, dispatchReceiverType, result2);
        } else if (obj instanceof FirClassLikeDeclaration) {
            this.loadClassLikeSpecificExperimentalities((FirClassLikeDeclaration)fir, $this$loadExperimentalities, context, visited2, result2);
        } else if (!(obj instanceof FirAnonymousInitializer || obj instanceof FirDanglingModifierList || obj instanceof FirFile || obj instanceof FirTypeParameter || obj instanceof FirScript || obj instanceof FirReplSnippet || obj instanceof FirCodeFragment || obj instanceof FirReceiverParameter)) {
            throw new NoWhenBranchMatchedException();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalities, FirResolvePhase.ANNOTATION_ARGUMENTS);
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)fir, session, (Collection<Experimentality>)result2, fromSupertype);
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)fir, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID(), session) != null && (accessibility = FirSinceKotlinHelpersKt.checkSinceKotlinVersionAccessibility(fir, context)) instanceof FirSinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            Iterable $this$forEach$iv = ((FirSinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(INSTANCE, (FirRegularClass)it.getFir(), session, null, 2, null));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCallableSpecificExperimentalities(FirCallableDeclaration $this$loadCallableSpecificExperimentalities, FirCallableSymbol<?> symbol, CheckerContext context, Set<FirDeclaration> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, SmartSet<Experimentality> result2) {
        block15: {
            FirRegularClassSymbol parentClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$loadCallableSpecificExperimentalities);
            FirRegularClassSymbol firRegularClassSymbol = parentClassSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null;
            if ($this$loadCallableSpecificExperimentalities instanceof FirConstructor) {
                FirClassLikeSymbol ownerClassLikeSymbol;
                FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirFunction)$this$loadCallableSpecificExperimentalities);
                FirClassLikeSymbol firClassLikeSymbol = ownerClassLikeSymbol = firTypeAliasSymbol != null ? (FirClassLikeSymbol)firTypeAliasSymbol : (FirClassLikeSymbol)parentClassSymbol;
                if (firClassLikeSymbol != null) {
                    this.loadExperimentalities(firClassLikeSymbol, context, result2, visited2, false, null, false);
                }
            } else {
                this.addExperimentalities(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType($this$loadCallableSpecificExperimentalities.getReturnTypeRef())), context, result2, visited2);
                Object object = $this$loadCallableSpecificExperimentalities.getReceiverParameter();
                this.addExperimentalities(object != null && (object = ((FirReceiverParameter)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf((ConeKotlinType)object) : null, context, result2, visited2);
            }
            FirCallableSymbol<?> $this$isStatic$iv = symbol;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) {
                ConeKotlinType coneKotlinType = dispatchReceiverType;
                if (coneKotlinType != null) {
                    this.addExperimentalities(coneKotlinType, context, result2, visited2);
                }
            }
            if ($this$loadCallableSpecificExperimentalities instanceof FirFunction) {
                boolean bl;
                Iterable $this$forEach$iv = ((FirFunction)$this$loadCallableSpecificExperimentalities).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    INSTANCE.addExperimentalities(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())), context, result2, visited2);
                }
                FirRegularClassSymbol firRegularClassSymbol2 = parentClassSymbol;
                if (firRegularClassSymbol2 != null) {
                    FirClassLikeSymbol $this$isData$iv = firRegularClassSymbol2;
                    boolean $i$f$isData = false;
                    bl = $this$isData$iv.getRawStatus().isData();
                } else {
                    bl = false;
                }
                if (bl && DataClassResolver.INSTANCE.isComponentLike(FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities)) && parentClassSymbol.getClassKind() == ClassKind.CLASS) {
                    FirPropertySymbol property;
                    Object v12;
                    block14: {
                        void $this$filterIsInstanceTo$iv$iv;
                        List<FirValueParameterSymbol> valueParameters2;
                        String string2 = FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities).getIdentifier();
                        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
                        int componentNIndex = DataClassResolver.INSTANCE.getComponentIndex(string2);
                        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorSymbol(parentClassSymbol, context.getSession());
                        List<FirValueParameterSymbol> list = valueParameters2 = firConstructorSymbol != null ? firConstructorSymbol.getValueParameterSymbols() : null;
                        FirValueParameterSymbol valueParameter2 = list != null ? CollectionsKt.getOrNull(list, componentNIndex - 1) : null;
                        Iterable $this$filterIsInstance$iv = parentClassSymbol.getDeclarationSymbols();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List properties2 = (List)destination$iv$iv;
                        Iterable $this$firstOrNull$iv = properties2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FirPropertySymbol it = (FirPropertySymbol)element$iv;
                            boolean bl3 = false;
                            FirValueParameterSymbol firValueParameterSymbol = valueParameter2;
                            if (!Intrinsics.areEqual(it.getName(), firValueParameterSymbol != null ? firValueParameterSymbol.getName() : null)) continue;
                            v12 = element$iv;
                            break block14;
                        }
                        v12 = null;
                    }
                    FirPropertySymbol firPropertySymbol = property = (FirPropertySymbol)v12;
                    if (firPropertySymbol != null) {
                        this.loadExperimentalities(firPropertySymbol, context, result2, visited2, false, dispatchReceiverType, false);
                    }
                }
            }
            if (!fromSetter || !(symbol instanceof FirPropertySymbol)) break block15;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)symbol).getSetterSymbol();
            if (firPropertyAccessorSymbol != null) {
                this.loadExperimentalities(firPropertyAccessorSymbol, context, result2, visited2, false, dispatchReceiverType, false);
            }
        }
    }

    private final void loadClassLikeSpecificExperimentalities(FirClassLikeDeclaration $this$loadClassLikeSpecificExperimentalities, FirBasedSymbol<?> symbol, CheckerContext context, Set<FirDeclaration> visited2, SmartSet<Experimentality> result2) {
        FirClassLikeDeclaration firClassLikeDeclaration = $this$loadClassLikeSpecificExperimentalities;
        if (firClassLikeDeclaration instanceof FirRegularClass) {
            if (symbol instanceof FirRegularClassSymbol) {
                FirClassLikeSymbol<?> parentClassSymbol;
                FirClassLikeSymbol<?> firClassLikeSymbol = parentClassSymbol = FirHelpersKt.outerClassSymbol((FirClassLikeSymbol)symbol, context);
                if (firClassLikeSymbol != null) {
                    this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context, result2, visited2, false, null, false);
                }
            }
        } else if (!(firClassLikeDeclaration instanceof FirAnonymousObject) && !(firClassLikeDeclaration instanceof FirTypeAlias)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addExperimentalities(ConeKotlinType $this$addExperimentalities, CheckerContext context, SmartSet<Experimentality> result2, Set<FirDeclaration> visited2) {
        if (!($this$addExperimentalities instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)$this$addExperimentalities).getLookupTag(), context.getSession());
        if (firClassLikeSymbol != null) {
            this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context, result2, visited2, false, null, false);
        }
        ConeTypeProjection[] $this$forEach$iv = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$addExperimentalities, context.getSession(), null, 2, null).getTypeArguments();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            INSTANCE.addExperimentalities(coneKotlinType, context, result2, visited2);
        }
    }

    static /* synthetic */ void addExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, SmartSet smartSet, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firOptInUsageBaseChecker.addExperimentalities(coneKotlinType, checkerContext, smartSet, set);
    }

    private final Experimentality loadExperimentalityForMarkerAnnotation(FirRegularClass $this$loadExperimentalityForMarkerAnnotation, FirSession session, String annotatedOwnerClassName) {
        Experimentality.Severity severity;
        Object v2;
        FirAnnotation experimental;
        block3: {
            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$loadExperimentalityForMarkerAnnotation, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session);
            if (firAnnotation == null) {
                return null;
            }
            experimental = firAnnotation;
            FirExpression levelArgument = FirAnnotationUtilsKt.findArgumentByName$default(experimental, LEVEL, false, 2, null);
            Object object = levelArgument;
            String levelName = object != null && (object = FirAnnotationUtilsKt.extractEnumValueArgumentInfo((FirExpression)object)) != null && (object = ((EnumValueArgumentInfo)object).getEnumEntryName()) != null ? ((Name)object).asString() : null;
            Iterable $this$firstOrNull$iv = Experimentality.Severity.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Experimentality.Severity it = (Experimentality.Severity)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), levelName)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((severity = (Experimentality.Severity)v2) == null) {
            severity = Experimentality.Companion.getDEFAULT_SEVERITY();
        }
        Experimentality.Severity severity2 = severity;
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(experimental, MESSAGE, false, 2, null);
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String message = object instanceof String ? (String)object : null;
        return new Experimentality($this$loadExperimentalityForMarkerAnnotation.getSymbol().getClassId(), severity2, message, annotatedOwnerClassName, false, 16, null);
    }

    static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClass firRegularClass, FirSession firSession, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClass, firSession, string2);
    }

    public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirElement element, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        boolean bl;
        Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirDeclaration object2 = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        FirClass firClass = object2 instanceof FirClass ? (FirClass)object2 : null;
        if (firClass != null) {
            FirClass it = firClass;
            boolean bl2 = false;
            bl = FirOptInAnnotationCallChecker.INSTANCE.getSubclassOptInApplicabilityAndMessage(it).getFirst();
        } else {
            bl = false;
        }
        boolean isSubclassOptInApplicable = bl;
        for (Experimentality experimentality : experimentalities) {
            Triple<KtDiagnosticFactory2<ClassId, String>, OptInInheritanceDiagnosticMessageProvider, String> triple;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String message = experimentality.component3();
            boolean fromSupertype = experimentality.component5();
            if (this.isExperimentalityAcceptableInContext(annotationClassId, context, fromSupertype)) continue;
            if (fromSupertype && severity == Experimentality.Severity.WARNING) {
                triple = new Triple<KtDiagnosticFactory2<ClassId, String>, OptInInheritanceDiagnosticMessageProvider, String>(FirErrors.INSTANCE.getOPT_IN_TO_INHERITANCE(), new OptInInheritanceDiagnosticMessageProvider(isSubclassOptInApplicable), "should");
            } else if (severity == Experimentality.Severity.WARNING) {
                triple = new Triple<KtDiagnosticFactory2<ClassId, String>, OptInUsagesDiagnosticMessageProvider, String>(FirErrors.INSTANCE.getOPT_IN_USAGE(), OptInUsagesDiagnosticMessageProvider.INSTANCE, "should");
            } else if (fromSupertype && severity == Experimentality.Severity.ERROR) {
                triple = new Triple<KtDiagnosticFactory2<ClassId, String>, OptInInheritanceDiagnosticMessageProvider, String>(FirErrors.INSTANCE.getOPT_IN_TO_INHERITANCE_ERROR(), new OptInInheritanceDiagnosticMessageProvider(isSubclassOptInApplicable), "must");
            } else if (severity == Experimentality.Severity.ERROR) {
                triple = new Triple<KtDiagnosticFactory2<ClassId, String>, OptInUsagesDiagnosticMessageProvider, String>(FirErrors.INSTANCE.getOPT_IN_USAGE_ERROR(), OptInUsagesDiagnosticMessageProvider.INSTANCE, "must");
            } else {
                throw new IllegalStateException(("Unexpected " + (Object)((Object)severity) + " type").toString());
            }
            Triple<KtDiagnosticFactory2<ClassId, String>, OptInInheritanceDiagnosticMessageProvider, String> triple2 = triple;
            KtDiagnosticFactory2<ClassId, String> diagnostic = triple2.component1();
            OptInDiagnosticMessageProvider messageProvider = triple2.component2();
            String verb = triple2.component3();
            CharSequence charSequence = message;
            String reportedMessage = !(charSequence == null || StringsKt.isBlank(charSequence)) ? messageProvider.buildCustomDiagnosticMessage(message) : messageProvider.buildDefaultDiagnosticMessage(annotationClassId.asFqNameString(), verb);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)annotationClassId, (Object)reportedMessage, (DiagnosticContext)context, null, 32, null);
        }
    }

    public static /* synthetic */ void reportNotAcceptedExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, Collection collection, FirElement firElement, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = firElement.getSource();
        }
        firOptInUsageBaseChecker.reportNotAcceptedExperimentalities(collection, firElement, checkerContext, diagnosticReporter, ktSourceElement);
    }

    public final void reportNotAcceptedOverrideExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirCallableSymbol<?> symbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (Experimentality experimentality : experimentalities) {
            Pair<KtDiagnosticFactory2<ClassId, String>, String> pair;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String markerMessage = experimentality.component3();
            String supertypeName = experimentality.component4();
            if (this.isExperimentalityAcceptable((FirAnnotationContainer)symbol.getFir(), context.getSession(), annotationClassId, false) || this.isExperimentalityAcceptableInContext(annotationClassId, context, false)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE(), "should");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE_ERROR(), "must");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair<KtDiagnosticFactory2<ClassId, String>, String> pair2 = pair;
            KtDiagnosticFactory2<ClassId, String> diagnostic = pair2.component1();
            String verb = pair2.component2();
            String string2 = supertypeName;
            if (string2 == null) {
                string2 = "???";
            }
            String message = OptInNames.INSTANCE.buildOverrideMessage(string2, markerMessage, verb, annotationClassId.asFqNameString());
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)symbol.getSource(), diagnostic, (Object)annotationClassId, (Object)message, (DiagnosticContext)context, null, 32, null);
        }
    }

    @Nullable
    public final KtSourceElement getSourceForIsMarkerDiagnostic(@NotNull FirAnnotationCall $this$getSourceForIsMarkerDiagnostic, int argumentIndex) {
        Intrinsics.checkNotNullParameter($this$getSourceForIsMarkerDiagnostic, "<this>");
        List<KtSourceElement> markerArgumentsSources = this.getMarkerArgumentsSources($this$getSourceForIsMarkerDiagnostic);
        return markerArgumentsSources.get(argumentIndex);
    }

    private final boolean isExperimentalityAcceptableInContext(ClassId annotationClassId, CheckerContext context, boolean fromSupertype) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        String fqNameAsString = annotationClassId.asFqNameString();
        if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(fqNameAsString)) {
            return true;
        }
        for (FirAnnotationContainer annotationContainer : context.getAnnotationContainers()) {
            if (!this.isExperimentalityAcceptable(annotationContainer, context.getSession(), annotationClassId, fromSupertype)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExperimentalityAcceptable(FirAnnotationContainer $this$isExperimentalityAcceptable, FirSession session, ClassId annotationClassId, boolean fromSupertype) {
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$isExperimentalityAcceptable, annotationClassId, session) != null || this.isAnnotatedWithOptIn($this$isExperimentalityAcceptable, annotationClassId, session) || fromSupertype && this.isAnnotatedWithSubclassOptInRequired($this$isExperimentalityAcceptable, session, annotationClassId) || this.primaryConstructorParameterIsExperimentalityAcceptable($this$isExperimentalityAcceptable, session, annotationClassId) || this.isImplicitDeclaration($this$isExperimentalityAcceptable);
    }

    private final boolean isImplicitDeclaration(FirAnnotationContainer $this$isImplicitDeclaration) {
        return $this$isImplicitDeclaration instanceof FirDeclaration && !Intrinsics.areEqual(((FirDeclaration)$this$isImplicitDeclaration).getOrigin(), FirDeclarationOrigin.Source.INSTANCE);
    }

    private final boolean primaryConstructorParameterIsExperimentalityAcceptable(FirAnnotationContainer $this$primaryConstructorParameterIsExperimentalityAcceptable, FirSession session, ClassId annotationClassId) {
        if (!($this$primaryConstructorParameterIsExperimentalityAcceptable instanceof FirProperty)) {
            return false;
        }
        FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirProperty)$this$primaryConstructorParameterIsExperimentalityAcceptable);
        if (firValueParameterSymbol == null) {
            return false;
        }
        FirValueParameterSymbol parameterSymbol = firValueParameterSymbol;
        return this.isExperimentalityAcceptable((FirAnnotationContainer)parameterSymbol.getFir(), session, annotationClassId, false);
    }

    private final boolean isAnnotatedWithOptIn(FirAnnotationContainer $this$isAnnotatedWithOptIn, ClassId annotationClassId, FirSession session) {
        for (FirAnnotation annotation : $this$isAnnotatedWithOptIn.getAnnotations()) {
            boolean bl;
            block4: {
                FirExpression annotationClasses;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null, OptInNames.INSTANCE.getOPT_IN_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses, session);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getClassId(), annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private final boolean isAnnotatedWithSubclassOptInRequired(FirAnnotationContainer $this$isAnnotatedWithSubclassOptInRequired, FirSession session, ClassId annotationClassId) {
        for (FirAnnotation annotation : $this$isAnnotatedWithSubclassOptInRequired.getAnnotations()) {
            boolean bl;
            block4: {
                FirExpression annotationClass;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClass, session);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getClassId(), annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtSourceElement> getMarkerArgumentsSources(FirAnnotationCall $this$getMarkerArgumentsSources) {
        List list;
        FirExpression annotationClasses = FirAnnotationUtilsKt.findArgumentByName$default($this$getMarkerArgumentsSources, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
        if (annotationClasses instanceof FirVarargArgumentsExpression) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((FirVarargArgumentsExpression)annotationClasses).getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSource());
            }
            list = (List)destination$iv$iv;
        } else {
            FirExpression firExpression = annotationClasses;
            list = CollectionsKt.listOfNotNull(firExpression != null ? firExpression.getSource() : null);
        }
        List markerArgumentsSources = list;
        return markerArgumentsSources;
    }

    static {
        Name name = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        LEVEL = name;
        Name name2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        MESSAGE = name2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0019\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0002)(B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJF\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\tH\u00c7\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0006H\u00d7\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010#\u001a\u0004\b$\u0010\u0018R\u001c\u0010\b\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b%\u0010\u0018R\u001a\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationClassId", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "severity", "", "message", "supertypeName", "", "fromSupertype", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;Ljava/lang/String;Z)V", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "component1", "()Lorg/jetbrains/kotlin/name/ClassId;", "component2", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "component3", "()Ljava/lang/String;", "component4", "component5", "()Z", "copy", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;Ljava/lang/String;Z)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "toString", "Lorg/jetbrains/kotlin/name/ClassId;", "getAnnotationClassId", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getSeverity", "Ljava/lang/String;", "getMessage", "getSupertypeName", "Z", "getFromSupertype", "Companion", "Severity"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @Nullable
        private final String supertypeName;
        private final boolean fromSupertype;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            this.annotationClassId = annotationClassId;
            this.severity = severity;
            this.message = message;
            this.supertypeName = supertypeName;
            this.fromSupertype = fromSupertype;
        }

        public /* synthetic */ Experimentality(ClassId classId, Severity severity, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(classId, severity, string2, string3, bl);
        }

        @NotNull
        public final ClassId getAnnotationClassId() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getSupertypeName() {
            return this.supertypeName;
        }

        public final boolean getFromSupertype() {
            return this.fromSupertype;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Experimentality)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.annotationClassId, ((Experimentality)other).annotationClassId)) {
                return false;
            }
            if (this.severity != ((Experimentality)other).severity) {
                return false;
            }
            if (!Intrinsics.areEqual(this.message, ((Experimentality)other).message)) {
                return false;
            }
            return this.fromSupertype == ((Experimentality)other).fromSupertype;
        }

        public int hashCode() {
            int result2 = this.annotationClassId.hashCode();
            result2 = 31 * result2 + this.severity.hashCode();
            String string2 = this.message;
            result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.fromSupertype);
            return result2;
        }

        @NotNull
        public final ClassId component1() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @Nullable
        public final String component4() {
            return this.supertypeName;
        }

        public final boolean component5() {
            return this.fromSupertype;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return new Experimentality(annotationClassId, severity, message, supertypeName, fromSupertype);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassId classId, Severity severity, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classId = experimentality.annotationClassId;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string2 = experimentality.message;
            }
            if ((n & 8) != 0) {
                string3 = experimentality.supertypeName;
            }
            if ((n & 0x10) != 0) {
                bl = experimentality.fromSupertype;
            }
            return experimentality.copy(classId, severity, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationClassId=" + this.annotationClassId + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", supertypeName=" + this.supertypeName + ", fromSupertype=" + this.fromSupertype + ')';
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "", "<init>", "(Ljava/lang/String;I)V", "WARNING", "ERROR"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value2) {
                return Enum.valueOf(Severity.class, value2);
            }

            @NotNull
            public static EnumEntries<Severity> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Experimentality.Severity.values().length];
            try {
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

