/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithCandidates;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u000f*\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInvisibleSetter", "isVisibilityError", "", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "(Lorg/jetbrains/kotlin/fir/references/FirReference;)Z", "checkValReassignmentViaBackingField", "checkValReassignmentOnValueParameterOrEnumEntry", "checkVariableExpected", "isConflictingError", "checkValReassignment", "isInFileGraph", "property", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isInOwnersInitializer", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkInvisibleSetter(expression, context, reporter);
        this.checkValReassignmentViaBackingField(expression, context, reporter);
        this.checkValReassignmentOnValueParameterOrEnumEntry(expression, context, reporter);
        this.checkVariableExpected(expression, context, reporter);
        this.checkValReassignment(expression, context, reporter);
    }

    private final void checkInvisibleSetter(FirVariableAssignment expression, CheckerContext context, DiagnosticReporter reporter) {
        block4: {
            Object object;
            KtDiagnosticFactory3<FirPropertySymbol, Visibility, CallableId> ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement;
            FirCallableSymbol callableSymbol;
            block6: {
                block5: {
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression);
                    boolean bl = firReference != null ? this.isVisibilityError(firReference) : false;
                    if (bl) {
                        return;
                    }
                    FirReference firReference2 = ReferenceUtilsKt.getCalleeReference(expression);
                    FirCallableSymbol firCallableSymbol = callableSymbol = firReference2 != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference2, false, 1, null) : null;
                    if (!(callableSymbol instanceof FirPropertySymbol) || !FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression, (FirPropertySymbol)callableSymbol)) break block4;
                    abstractKtSourceElement = expression.getLValue().getSource();
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getINVISIBLE_SETTER();
                    object = ((FirPropertySymbol)callableSymbol).getSetterSymbol();
                    if (object == null) break block5;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getResolvedStatus().getVisibility();
                    if (object != null) break block6;
                }
                object = Visibilities.Private.INSTANCE;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)callableSymbol, object, (Object)((FirPropertySymbol)callableSymbol).getCallableId(), (DiagnosticContext)context, null, 64, null);
        }
    }

    private final boolean isVisibilityError(FirReference $this$isVisibilityError) {
        return $this$isVisibilityError instanceof FirResolvedErrorReference && ((FirResolvedErrorReference)$this$isVisibilityError).getDiagnostic() instanceof ConeVisibilityError;
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression, CheckerContext context, DiagnosticReporter reporter) {
        Object object;
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression);
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirPropertyAccessor it = (FirPropertyAccessor)firElement2;
                boolean bl = false;
                firElement = it.isGetter() ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((object = (FirPropertyAccessor)firElement) == null || (object = ((FirPropertyAccessor)object).getSymbol()) == null) {
            return;
        }
        Object closestGetter = object;
        if (!Intrinsics.areEqual(propertySymbol.getGetterSymbol(), closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameterOrEnumEntry(FirVariableAssignment expression, CheckerContext context, DiagnosticReporter reporter) {
        FirVariableSymbol symbol;
        FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression);
        FirVariableSymbol firVariableSymbol = symbol = firReference != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference, false, 1, null) : null;
        if (symbol instanceof FirValueParameterSymbol || symbol instanceof FirEnumEntrySymbol) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)symbol, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkVariableExpected(FirVariableAssignment expression, CheckerContext context, DiagnosticReporter reporter) {
        block4: {
            block3: {
                FirReference calleeReference = ReferenceUtilsKt.getCalleeReference(expression);
                if (!(FirExpressionUtilKt.unwrapLValue(expression) instanceof FirPropertyAccessExpression)) break block3;
                FirReference firReference = calleeReference;
                if (firReference != null ? this.isConflictingError(firReference) : false) break block4;
                FirReference firReference2 = calleeReference;
                if ((firReference2 != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference2, false, 1, null) : null) != null) break block4;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getLValue().getSource(), FirErrors.INSTANCE.getVARIABLE_EXPECTED(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isConflictingError(FirReference $this$isConflictingError) {
        boolean bl;
        block10: {
            if (!FirReferenceUtilsKt.isError($this$isConflictingError)) {
                return false;
            }
            ConeDiagnostic it = ((FirDiagnosticHolder)((Object)$this$isConflictingError)).getDiagnostic();
            if (it instanceof ConeSimpleDiagnostic) {
                bl = ((ConeSimpleDiagnostic)it).getKind() == DiagnosticKind.VariableExpected;
            } else if (it instanceof ConeUnresolvedNameError) {
                bl = true;
            } else if (it instanceof ConeDiagnosticWithCandidates) {
                Iterable $this$any$iv = ((ConeDiagnosticWithCandidates)it).getCandidates();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractCandidate it2 = (AbstractCandidate)element$iv;
                        boolean bl2 = false;
                        if (!(it2.getSymbol() instanceof FirPropertySymbol)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void checkValReassignment(FirVariableAssignment expression, CheckerContext context, DiagnosticReporter reporter) {
        Object object = ReferenceUtilsKt.getCalleeReference(expression);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object property = object;
        if (((FirVariableSymbol)property).isVar()) {
            return;
        }
        if ((((FirPropertySymbol)property).isLocal() || this.isInFileGraph((FirPropertySymbol)property, context)) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property, false)) {
            return;
        }
        FirExpression firExpression = FirExpressionUtilKt.getDispatchReceiver(expression);
        if (this.isInOwnersInitializer(firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null, context) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property, true)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), property, (DiagnosticContext)context, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInFileGraph(FirPropertySymbol property, CheckerContext context) {
        Object v2;
        void $this$reduceOrNull$iv;
        FirDeclaration firDeclaration;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$dropWhile$iv = context.getContainingDeclarations();
        boolean $i$f$dropWhile = false;
        boolean yielding$iv22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv22) {
                list$iv.add(item$iv);
                continue;
            }
            FirDeclaration it = (FirDeclaration)item$iv;
            boolean bl = false;
            if (!(it instanceof FirFile)) continue;
            list$iv.add(item$iv);
            yielding$iv22 = true;
        }
        List declarations2 = list$iv;
        Object yielding$iv22 = CollectionsKt.firstOrNull(declarations2);
        FirFile firFile = yielding$iv22 instanceof FirFile ? (FirFile)yielding$iv22 : null;
        if (firFile == null) {
            return false;
        }
        FirFile file2 = firFile;
        if (!Intrinsics.areEqual(file2.getSymbol(), FirHelpersKt.getContainingSymbol(property, context.getSession()))) {
            return false;
        }
        yielding$iv22 = declarations2;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            firDeclaration = (FirDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirElement firElement = it instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)it : null;
            collection.add(firElement != null && (firElement = firElement.getControlFlowGraphReference()) != null ? FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)firElement) : null);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                FirDeclaration firDeclaration2;
                void graph2;
                ControlFlowGraph $i$f$mapTo2 = (ControlFlowGraph)iterator$iv.next();
                ControlFlowGraph acc = (ControlFlowGraph)accumulator$iv;
                boolean bl = false;
                if (graph2 != null) {
                    FirDeclaration it = firDeclaration;
                    boolean bl2 = false;
                    firDeclaration2 = acc != null && acc.getSubGraphs().contains(it) ? firDeclaration : null;
                } else {
                    firDeclaration2 = null;
                }
                accumulator$iv = firDeclaration2;
            }
            v2 = accumulator$iv;
        }
        ControlFlowGraph containingGraph = v2;
        return containingGraph != null;
    }

    private final boolean isInOwnersInitializer(FirExpression receiver, CheckerContext context) {
        int index2;
        List<FirDeclaration> containingDeclarations;
        block7: {
            int n;
            Object object = receiver instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)receiver : null;
            if (object == null || (object = ((FirThisReceiverExpression)object).getCalleeReference()) == null || (object = ((FirThisReference)object).getBoundSymbol()) == null) {
                return false;
            }
            Object uninitializedThisSymbol = object;
            List<FirDeclaration> $this$indexOfFirst$iv = containingDeclarations = context.getContainingDeclarations();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<FirDeclaration> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                FirDeclaration item$iv;
                FirDeclaration it = item$iv = iterator2.next();
                boolean bl = false;
                if (it instanceof FirClass && Intrinsics.areEqual(((FirClass)it).getSymbol(), uninitializedThisSymbol)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = index2 = -1;
        }
        if (index2 == -1) {
            return false;
        }
        int n = containingDeclarations.size();
        for (int i = index2; i < n; ++i) {
            FirDeclaration container;
            FirDeclaration firDeclaration;
            block10: {
                FirDeclaration next;
                block8: {
                    block9: {
                        FirDeclaration firDeclaration2;
                        if (!(containingDeclarations.get(i) instanceof FirClass)) continue;
                        next = CollectionsKt.getOrNull(containingDeclarations, i + 1);
                        if (!(next instanceof FirProperty)) break block8;
                        firDeclaration = CollectionsKt.getOrNull(containingDeclarations, i + 2);
                        if (firDeclaration == null) break block9;
                        FirDeclaration it = firDeclaration2 = firDeclaration;
                        boolean bl = false;
                        firDeclaration = it instanceof FirPropertyAccessor ? firDeclaration2 : null;
                        if (firDeclaration != null) break block10;
                    }
                    firDeclaration = next;
                    break block10;
                }
                firDeclaration = next;
            }
            FirDeclaration firDeclaration3 = container = firDeclaration;
            boolean bl = firDeclaration3 != null ? !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firDeclaration3) : false;
            if (!bl) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final boolean checkInvisibleSetter$shouldInvisibleSetterBeReported(CheckerContext $context, FirVariableAssignment $expression, FirPropertySymbol symbol) {
        $this$unwrapFakeOverrides$iv = symbol;
        $i$f$unwrapFakeOverrides = false;
        $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
        $i$f$unwrapFakeOverrides = false;
        current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv$iv /* !! */  = current$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv /* !! */ ;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv /* !! */ ;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            current$iv$iv = next$iv$iv = v1;
        }
        v2 = current$iv$iv.getSymbol();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
        }
        v3 = ((FirPropertySymbol)((FirCallableSymbol)((FirPropertySymbol)v2))).getSetterSymbol();
        v4 = setterFir = v3 != null ? (FirPropertyAccessor)v3.getFir() : null;
        if (setterFir != null) {
            block9: {
                var4_17 = $context;
                var19_18 = $context.getSession();
                var18_19 = setterFir;
                var17_20 = FirVisibilityCheckerKt.getVisibilityChecker($context.getSession());
                $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    v5 = it$iv;
                    if (!(v5 instanceof FirFile)) {
                        v5 = null;
                    }
                    if ((v6 = (FirElement)((FirFile)v5)) == null) continue;
                    var9_8 = v6;
                    $this$originalIfFakeOverride$iv$iv$iv /* !! */  = var9_8;
                    $i$a$-findClosest-CheckerContextKt$findClosest$1 = false;
                    it /* !! */  = $this$originalIfFakeOverride$iv$iv$iv /* !! */ ;
                    v6 = true != false ? var9_8 : null;
                    if (v6 == null) {
                        continue;
                    }
                    break block9;
                }
                v6 = null;
            }
            v7 = var20_21 = v6;
            Intrinsics.checkNotNull(v7);
            return FirVisibilityChecker.isVisible$default(var17_20, var18_19, var19_18, (FirFile)v7, $context.getContainingDeclarations(), FirExpressionUtilKt.getDispatchReceiver($expression), false, null, false, null, 480, null) == false;
        }
        return false;
    }
}

