/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import com.intellij.lang.LighterASTNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "data", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "analyze", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "ReassignedVariableCollector"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();

    private CanBeValChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull VariableInitializationInfoData data2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Iterator<FirVariableSymbol<?>> iterator2;
        ReassignedVariableCollector reassignedVariableCollector;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean isForInitialization = data2.getGraph().getKind() == ControlFlowGraph.Kind.Class || data2.getGraph().getKind() == ControlFlowGraph.Kind.File;
        ReassignedVariableCollector $this$analyze_u24lambda_u240 = reassignedVariableCollector = new ReassignedVariableCollector(data2, isForInitialization);
        boolean bl = false;
        data2.getGraph().traverse($this$analyze_u24lambda_u240);
        ReassignedVariableCollector collector2 = reassignedVariableCollector;
        Iterator<FirVariableSymbol<?>> iterator3 = iterator2 = data2.getProperties().iterator();
        while (iterator3.hasNext()) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            boolean canBeVal;
            boolean bl2;
            KtSourceElement source;
            FirVariableSymbol<?> symbol = iterator3.next();
            if (symbol.getSource() == null) continue;
            if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                void $this$fold$iv;
                int n;
                Iterable $this$count$iv = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count2 = n;
                $this$count$iv = RangesKt.until(0, count2);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                Iterator iterator4 = $this$fold$iv.iterator();
                while (iterator4.hasNext()) {
                    int element$iv = ((IntIterator)iterator4).nextInt();
                    boolean acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = iterator2.hasNext() && collector2.canBeVal(iterator2.next()) && acc;
                }
                bl2 = accumulator$iv;
            } else {
                bl2 = collector2.canBeVal(symbol);
            }
            if (!(canBeVal = bl2)) continue;
            if (symbol instanceof FirPropertySymbol && !FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol, isForInitialization)) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getCAN_BE_VAL();
            } else {
                FirCallableSymbol $this$isLateInit$iv = symbol;
                boolean $i$f$isLateInit = false;
                ktDiagnosticFactory0 = $this$isLateInit$iv.getRawStatus().isLateInit() ? FirErrors.INSTANCE.getCAN_BE_VAL_LATEINIT() : FirErrors.INSTANCE.getCAN_BE_VAL_DELAYED_INITIALIZATION();
            }
            KtDiagnosticFactory0 diagnostic = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (DiagnosticContext)context, null, 8, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0015\u001a\u00020\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker$ReassignedVariableCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "data", "", "isForInitialization", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Z)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "node", "", "visitNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableDeclarationNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableAssignmentNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "symbol", "canBeVal", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;)Z", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "Z", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "declaredIn", "Ljava/util/Map;", "", "reassigned", "Ljava/util/Set;"})
    private static final class ReassignedVariableCollector
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final VariableInitializationInfoData data;
        private final boolean isForInitialization;
        @NotNull
        private final Map<FirPropertySymbol, ControlFlowGraph> declaredIn;
        @NotNull
        private final Set<FirPropertySymbol> reassigned;

        public ReassignedVariableCollector(@NotNull VariableInitializationInfoData data2, boolean isForInitialization) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this.data = data2;
            this.isForInitialization = isForInitialization;
            this.declaredIn = new LinkedHashMap();
            this.reassigned = new LinkedHashSet();
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            this.declaredIn.put(node.getFir().getSymbol(), FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(node.getFir());
            Object object = firReference;
            if (firReference == null) return;
            if ((object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object symbol = object;
            if (!((FirVariableSymbol)symbol).isVar()) return;
            KtSourceElement ktSourceElement = ((FirBasedSymbol)symbol).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) return;
            if (!this.data.getProperties().contains(symbol)) return;
            if (FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol, this.isForInitialization)) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = this.data.getValue(node).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PersistentMap it = (PersistentMap)element$iv;
                            boolean bl2 = false;
                            MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)it.get(symbol);
                            boolean bl3 = markedEventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                            if (!bl3) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    if (Intrinsics.areEqual(this.declaredIn.get(symbol), FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()))) return;
                }
            }
            boolean bl = true;
            boolean isReassigned = bl;
            if (!isReassigned) return;
            this.reassigned.add((FirPropertySymbol)symbol);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canBeVal(@NotNull FirVariableSymbol<?> symbol) {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            if (!(symbol instanceof FirPropertySymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!((FirPropertySymbol)symbol).isVar()) return false;
            if (((FirPropertySymbol)symbol).getHasDelegate()) return false;
            KtSourceElement ktSourceElement = ((FirPropertySymbol)symbol).getSource();
            if (ktSourceElement == null) return false;
            KtSourceElementKind ktSourceElementKind = ktSourceElement.getKind();
            if (ktSourceElementKind == null) {
                return false;
            }
            boolean bl = ktSourceElementKind instanceof KtFakeSourceElementKind;
            if (bl) return false;
            if (this.reassigned.contains(symbol)) return false;
            return true;
        }
    }
}

