/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002H\u0002R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnonymousFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getReportableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "unusedParamsVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "LambdaBodyContext", "checkers"})
public final class FirAnonymousUnusedParamChecker
extends FirDeclarationChecker<FirAnonymousFunction> {
    @NotNull
    public static final FirAnonymousUnusedParamChecker INSTANCE = new FirAnonymousUnusedParamChecker();
    @NotNull
    private static final FirVisitor<Unit, Set<FirValueParameterSymbol>> unusedParamsVisitor = new FirVisitor<Unit, Set<FirValueParameterSymbol>>(){

        public void visitElement(FirElement element, Set<FirValueParameterSymbol> data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!((Collection)data2).isEmpty()) {
                element.acceptChildren(this, data2);
            }
        }

        public void visitResolvedNamedReference(FirResolvedNamedReference resolvedNamedReference, Set<FirValueParameterSymbol> data2) {
            Intrinsics.checkNotNullParameter(resolvedNamedReference, "resolvedNamedReference");
            Intrinsics.checkNotNullParameter(data2, "data");
            Collection collection = data2;
            FirBasedSymbol<?> firBasedSymbol = resolvedNamedReference.getResolvedSymbol();
            TypeIntrinsics.asMutableCollection(collection).remove(firBasedSymbol);
        }

        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, Set<FirValueParameterSymbol> data2) {
            Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!anonymousFunction.isLambda()) {
                this.visitElement((FirElement)anonymousFunction, data2);
                return;
            }
            data2.addAll(FirAnonymousUnusedParamChecker.access$getReportableParameters(FirAnonymousUnusedParamChecker.INSTANCE, anonymousFunction));
            anonymousFunction.acceptChildren(this, data2);
        }
    };

    private FirAnonymousUnusedParamChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnonymousFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block0: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            LambdaBodyContext lambdaBodyContext = context.getLambdaBodyContext();
            if (lambdaBodyContext == null) break block0;
            lambdaBodyContext.checkUnusedParams$checkers(declaration, context, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FirValueParameterSymbol> getReportableParameters(FirAnonymousFunction $this$getReportableParameters) {
        void var3_4;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getReportableParameters.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            KtSourceElement ktSourceElement = it.getSource();
            if (!(!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && !Intrinsics.areEqual(it.getName(), SpecialNames.UNDERSCORE_FOR_UNUSED_VAR))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (Set)var3_4;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "outermostLambda", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)V", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "checkUnusedParams$checkers", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkUnusedParams", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;"})
    public static final class LambdaBodyContext {
        @NotNull
        private final FirAnonymousFunction outermostLambda;

        public LambdaBodyContext(@NotNull FirAnonymousFunction outermostLambda) {
            Intrinsics.checkNotNullParameter(outermostLambda, "outermostLambda");
            this.outermostLambda = outermostLambda;
        }

        public final void checkUnusedParams$checkers(@NotNull FirAnonymousFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (!Intrinsics.areEqual(declaration, this.outermostLambda)) {
                return;
            }
            Set unusedParams = INSTANCE.getReportableParameters(declaration);
            FirBlock firBlock = declaration.getBody();
            if (firBlock != null) {
                firBlock.accept(unusedParamsVisitor, unusedParams);
            }
            Iterable $this$forEach$iv = unusedParams;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getUNUSED_ANONYMOUS_PARAMETER(), (Object)it, (DiagnosticContext)context, null, 16, null);
            }
        }
    }
}

