/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.FirUnusedExpressionCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "UsageState", "UsageVisitor", "checkers"})
public final class FirUnusedExpressionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirUnusedExpressionChecker INSTANCE = new FirUnusedExpressionChecker();

    private FirUnusedExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block3: {
            FirDeclaration firDeclaration;
            UsageVisitor visitor2;
            block6: {
                block5: {
                    block4: {
                        block2: {
                            Intrinsics.checkNotNullParameter(declaration, "declaration");
                            Intrinsics.checkNotNullParameter(context, "context");
                            Intrinsics.checkNotNullParameter(reporter, "reporter");
                            visitor2 = new UsageVisitor(context, reporter);
                            firDeclaration = declaration;
                            if (!(firDeclaration instanceof FirReplSnippet)) break block2;
                            ((FirReplSnippet)declaration).getBody().acceptChildren(visitor2, UsageState.Used);
                            break block3;
                        }
                        if (!(firDeclaration instanceof FirCodeFragment)) break block4;
                        ((FirCodeFragment)declaration).getBlock().acceptChildren(visitor2, UsageState.Used);
                        break block3;
                    }
                    if (!(firDeclaration instanceof FirAnonymousInitializer)) break block5;
                    FirBlock firBlock = ((FirAnonymousInitializer)declaration).getBody();
                    if (firBlock == null) break block3;
                    firBlock.acceptChildren(visitor2, UsageState.Unused);
                    break block3;
                }
                if (!(firDeclaration instanceof FirFunction)) break block6;
                boolean lastStatementUsed = declaration instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration).isLambda();
                FirBlock firBlock = ((FirFunction)declaration).getBody();
                if (firBlock == null) break block3;
                firBlock.accept(visitor2, lastStatementUsed ? UsageState.Used : UsageState.Unused);
                break block3;
            }
            if (!(firDeclaration instanceof FirVariable)) break block3;
            FirExpression firExpression = ((FirVariable)declaration).getInitializer();
            if (firExpression != null) {
                firExpression.accept(visitor2, UsageState.Used);
            }
            FirExpression firExpression2 = ((FirVariable)declaration).getDelegate();
            if (firExpression2 != null) {
                firExpression2.accept(visitor2, UsageState.Used);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;", "", "<init>", "(Ljava/lang/String;I)V", "Used", "Unused"})
    private static final class UsageState
    extends Enum<UsageState> {
        public static final /* enum */ UsageState Used = new UsageState();
        public static final /* enum */ UsageState Unused = new UsageState();
        private static final /* synthetic */ UsageState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UsageState[] values() {
            return (UsageState[])$VALUES.clone();
        }

        public static UsageState valueOf(String value2) {
            return Enum.valueOf(UsageState.class, value2);
        }

        @NotNull
        public static EnumEntries<UsageState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = usageStateArray = new UsageState[]{UsageState.Used, UsageState.Unused};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010!\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotation", "visitAnnotation", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "whenExpression", "visitWhenExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "tryExpression", "visitTryExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "block", "visitBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "loop", "visitLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirLoop;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;"})
    private static final class UsageVisitor
    extends FirDefaultVisitor<Unit, UsageState> {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public UsageVisitor(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            this.context = context;
            this.reporter = reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull UsageState data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter((Object)data2, "data");
            if (element instanceof FirDeclaration) {
                return;
            }
            KtSourceElement source = element.getSource();
            if (data2 == UsageState.Unused && element instanceof FirExpression && source != null && !FirUnusedExpressionCheckerKt.access$hasSideEffect((FirExpression)element)) {
                KtDiagnosticFactory0 factory2 = element instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)element).getAnonymousFunction().isLambda() ? FirErrors.INSTANCE.getUNUSED_LAMBDA_EXPRESSION() : FirErrors.INSTANCE.getUNUSED_EXPRESSION();
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)this.context, null, 8, null);
                return;
            }
            element.acceptChildren(this, UsageState.Used);
        }

        @Override
        public void visitAnnotation(@NotNull FirAnnotation annotation, @NotNull UsageState data2) {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Intrinsics.checkNotNullParameter((Object)data2, "data");
        }

        @Override
        public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull UsageState data2) {
            Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
            Intrinsics.checkNotNullParameter((Object)data2, "data");
            FirVariable variable = whenExpression.getSubjectVariable();
            if (variable == null) {
                FirExpression firExpression = whenExpression.getSubject();
                if (firExpression != null) {
                    firExpression.accept(this, UsageState.Used);
                }
            } else {
                variable.accept(this, UsageState.Used);
            }
            for (FirWhenBranch branch : whenExpression.getBranches()) {
                branch.getCondition().accept(this, UsageState.Used);
                branch.getResult().accept(this, data2);
            }
        }

        @Override
        public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull UsageState data2) {
            block1: {
                Intrinsics.checkNotNullParameter(tryExpression, "tryExpression");
                Intrinsics.checkNotNullParameter((Object)data2, "data");
                tryExpression.getTryBlock().accept(this, data2);
                for (FirCatch firCatch : tryExpression.getCatches()) {
                    firCatch.getBlock().accept(this, data2);
                }
                FirBlock firBlock = tryExpression.getFinallyBlock();
                if (firBlock == null) break block1;
                firBlock.accept(this, UsageState.Unused);
            }
        }

        @Override
        public void visitBlock(@NotNull FirBlock block, @NotNull UsageState data2) {
            Intrinsics.checkNotNullParameter(block, "block");
            Intrinsics.checkNotNullParameter((Object)data2, "data");
            KtSourceElement ktSourceElement = block.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement) {
                return;
            }
            if (block instanceof FirContractCallBlock) {
                return;
            }
            List<FirStatement> statements = block.getStatements();
            int lastIndex = CollectionsKt.getLastIndex(statements);
            int n = ((Collection)statements).size();
            for (int i = 0; i < n; ++i) {
                FirStatement statement = statements.get(i);
                boolean isImplicitReturn = i == lastIndex && statement instanceof FirExpression && TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType((FirExpression)statement), FirTypeUtilsKt.getResolvedType(block), this.context.getSession(), false, 4, null);
                statement.accept(this, isImplicitReturn ? data2 : UsageState.Unused);
            }
        }

        @Override
        public void visitLoop(@NotNull FirLoop loop, @NotNull UsageState data2) {
            Intrinsics.checkNotNullParameter(loop, "loop");
            Intrinsics.checkNotNullParameter((Object)data2, "data");
            loop.getCondition().accept(this, UsageState.Used);
            loop.getBlock().accept(this, UsageState.Unused);
        }
    }
}

