/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0018\u0010\u0011\u001a\u00020\u000e*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "data", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "analyze", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "", "getIgnoreWarnings", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "ignoreWarnings", "Data", "AddAllWrites", "FindVisibleWrites", "RemoveVisibleWrites"})
public final class UnusedChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void analyze(@NotNull VariableInitializationInfoData data2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        Set<FirVariableSymbol<?>> set = data2.getProperties();
        Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol>");
        Set<FirVariableSymbol<?>> properties2 = set;
        Data ownData = new Data(properties2);
        data2.getGraph().traverse(new AddAllWrites(ownData));
        if (!ownData.getUnreadWrites().isEmpty()) {
            ownData.setWritesByNode(CfgTraverserKt.traverseToFixedPoint(data2.getGraph(), new FindVisibleWrites(properties2)));
        }
        data2.getGraph().traverse(new RemoveVisibleWrites(ownData));
        Set variablesWithUnobservedWrites = new LinkedHashSet();
        for (Map.Entry<FirStatement, ControlFlowGraph> entry : ownData.getUnreadWrites().entrySet()) {
            FirStatement statement = entry.getKey();
            ControlFlowGraph scope2 = entry.getValue();
            if (statement instanceof FirVariableAssignment) {
                Object object = ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)statement);
                if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) continue;
                Object variableSymbol = object;
                variablesWithUnobservedWrites.add(variableSymbol);
                if (!ownData.getVariablesWithoutReads().containsKey(variableSymbol) && !Intrinsics.areEqual(scope2, ownData.getVariableScopes().get(variableSymbol))) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirVariableAssignment)statement).getLValue().getSource(), FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), (DiagnosticContext)context, null, 8, null);
                continue;
            }
            if (!(statement instanceof FirProperty) || ownData.getVariablesWithoutReads().containsKey(((FirProperty)statement).getSymbol()) || this.getIgnoreWarnings(((FirProperty)statement).getSymbol())) continue;
            FirExpression firExpression = ((FirProperty)statement).getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), (DiagnosticContext)context, null, 8, null);
        }
        for (Map.Entry<Object, Object> entry : ownData.getVariablesWithoutReads().entrySet()) {
            FirPropertySymbol symbol = (FirPropertySymbol)entry.getKey();
            FirProperty fir = (FirProperty)entry.getValue();
            if (this.getIgnoreWarnings(symbol)) continue;
            FirExpression firExpression = fir.getInitializer();
            FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
            if ((firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) || Intrinsics.areEqual(ClassMembersKt.isCatchParameter(fir), true)) continue;
            KtDiagnosticFactory0 error = variablesWithUnobservedWrites.contains(symbol) ? FirErrors.INSTANCE.getVARIABLE_NEVER_READ() : FirErrors.INSTANCE.getUNUSED_VARIABLE();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)fir.getSource(), error, (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getIgnoreWarnings(FirPropertySymbol $this$ignoreWarnings) {
        if (Intrinsics.areEqual($this$ignoreWarnings.getName(), SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) return true;
        if ($this$ignoreWarnings.getSource() == null) return true;
        KtSourceElement ktSourceElement = $this$ignoreWarnings.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredAugmentedAssign) return true;
        KtSourceElement ktSourceElement2 = $this$ignoreWarnings.getSource();
        if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null, KtNodeTypes.DESTRUCTURING_DECLARATION)) return true;
        KtSourceElement ktSourceElement3 = $this$ignoreWarnings.getInitializerSource();
        if (!Intrinsics.areEqual(ktSourceElement3 != null ? ktSourceElement3.getKind() : null, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) return false;
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$AddAllWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "data", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "node", "", "visitNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableDeclarationNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableAssignmentNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;"})
    private static final class AddAllWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public AddAllWrites(@NotNull Data data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this.data = data2;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            if (node.getFir().getName().isSpecial()) {
                return;
            }
            ControlFlowGraph graph2 = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner());
            if (node.getFir().getInitializer() != null) {
                this.data.getUnreadWrites().put(node.getFir(), graph2);
            }
            this.data.getVariableScopes().put(node.getFir().getSymbol(), graph2);
            this.data.getVariablesWithoutReads().put(node.getFir().getSymbol(), node.getFir());
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
            if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object propertySymbol = object;
            if (((FirCallableSymbol)propertySymbol).getName().isSpecial()) {
                return;
            }
            if (this.data.getLocalProperties().contains(propertySymbol)) {
                this.data.getUnreadWrites().put(node.getFir(), FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRr\u0010\t\u001aZ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012L\u0012J\u0012\u0004\u0012\u00020\r\u0012<\u0012:\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000ej\u0002`\u000f0\fj\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000ej\u0002`\u000f`\u00100\fj\u0002`\u00110\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "getLocalProperties", "()Ljava/util/Set;", "writesByNode", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lkotlinx/collections/immutable/PersistentSet;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PathAwareVariableWriteInfo;", "getWritesByNode", "()Ljava/util/Map;", "setWritesByNode", "(Ljava/util/Map;)V", "unreadWrites", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "getUnreadWrites", "variableScopes", "getVariableScopes", "variablesWithoutReads", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariablesWithoutReads", "checkers"})
    private static final class Data {
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> writesByNode;
        @NotNull
        private final Map<FirStatement, ControlFlowGraph> unreadWrites;
        @NotNull
        private final Map<FirPropertySymbol, ControlFlowGraph> variableScopes;
        @NotNull
        private final Map<FirPropertySymbol, FirProperty> variablesWithoutReads;

        public Data(@NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter(localProperties, "localProperties");
            this.localProperties = localProperties;
            this.writesByNode = MapsKt.emptyMap();
            this.unreadWrites = new LinkedHashMap();
            this.variableScopes = new LinkedHashMap();
            this.variablesWithoutReads = new LinkedHashMap();
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>>> getWritesByNode() {
            return this.writesByNode;
        }

        public final void setWritesByNode(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.writesByNode = map2;
        }

        @NotNull
        public final Map<FirStatement, ControlFlowGraph> getUnreadWrites() {
            return this.unreadWrites;
        }

        @NotNull
        public final Map<FirPropertySymbol, ControlFlowGraph> getVariableScopes() {
            return this.variableScopes;
        }

        @NotNull
        public final Map<FirPropertySymbol, FirProperty> getVariablesWithoutReads() {
            return this.variablesWithoutReads;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u0001B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ~\u0010\n\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u00ba\u0001\u0010\u0010\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013*J\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0014\u0010\u0015\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005H\u0002J\u00a8\u0001\u0010\u0016\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u000f\u001a\u00020\u00172N\u0010\u0015\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013H\u0016J\u00a8\u0001\u0010\u0018\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u000f\u001a\u00020\u00192N\u0010\u0015\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$FindVisibleWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lkotlinx/collections/immutable/PersistentSet;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWrites;", "properties", "", "<init>", "(Ljava/util/Set;)V", "mergeInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteInfo;", "a", "b", "node", "overwrite", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PathAwareVariableWriteInfo;", "symbol", "data", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    private static final class FindVisibleWrites
    extends PathAwareControlFlowGraphVisitor<FirPropertySymbol, PersistentSet<? extends CFGNode<?>>> {
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindVisibleWrites(@NotNull Set<? extends FirPropertySymbol> properties2) {
            Intrinsics.checkNotNullParameter(properties2, "properties");
            this.properties = properties2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> mergeInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> a, @NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> b, @NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(node, "node");
            PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> $this$merge$iv = a;
            boolean $i$f$merge = false;
            PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder<FirPropertySymbol, PersistentSet<CFGNode<?>>> builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = b;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                Map map2;
                Object k;
                block4: {
                    Object rightValue$iv;
                    block3: {
                        void p1;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = it$iv;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv.getKey();
                        map2 = map3;
                        boolean bl3 = false;
                        Object label$iv = entry2.getKey();
                        rightValue$iv = entry2.getValue();
                        object = $this$merge$iv.get(label$iv);
                        if (object == null) break block3;
                        Object leftValue$iv = object;
                        boolean bl4 = false;
                        Collection collection = (Collection)rightValue$iv;
                        PersistentSet p0 = (PersistentSet)leftValue$iv;
                        boolean bl5 = false;
                        PersistentSet persistentSet = p0.addAll(p1);
                        object = persistentSet;
                        if (persistentSet != null) break block4;
                    }
                    object = rightValue$iv;
                }
                Object v = object;
                map2.put(k, v);
            }
            return builder2.build();
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> overwrite(PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> $this$overwrite, FirPropertySymbol symbol, PersistentSet<? extends CFGNode<?>> data2) {
            PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> $this$transformValues$iv = $this$overwrite;
            boolean $i$f$transformValues = false;
            PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> $this$mutate$iv$iv = $this$transformValues$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = $this$transformValues$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = it$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl3 = false;
                Object values$iv = entry2.getValue();
                PersistentMap it = (PersistentMap)values$iv;
                boolean bl4 = false;
                PersistentMap<FirPropertySymbol, PersistentSet<? extends CFGNode<?>>> persistentMap = it.put(symbol, data2);
                map3.put(k, persistentMap);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data2) {
            PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> persistentMap;
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (node.getFir().getName().isSpecial()) {
                persistentMap = data2;
            } else {
                PersistentSet<Object> persistentSet;
                FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
                if (node.getFir().getInitializer() != null) {
                    VariableDeclarationNode[] variableDeclarationNodeArray = new VariableDeclarationNode[]{node};
                    persistentSet = ExtensionsKt.persistentSetOf(variableDeclarationNodeArray);
                } else {
                    persistentSet = ExtensionsKt.persistentSetOf();
                }
                persistentMap = this.overwrite(data2, firPropertySymbol, persistentSet);
            }
            return persistentMap;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data2) {
            Object object;
            block5: {
                block4: {
                    Object object2;
                    Intrinsics.checkNotNullParameter(node, "node");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block4;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block5;
                }
                return data2;
            }
            Object symbol = object;
            if (((FirCallableSymbol)symbol).getName().isSpecial()) {
                return data2;
            }
            VariableAssignmentNode[] variableAssignmentNodeArray = new VariableAssignmentNode[]{node};
            return this.overwrite(data2, (FirPropertySymbol)symbol, ExtensionsKt.persistentSetOf(variableAssignmentNodeArray));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\nJ#\u0010\u0014\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$RemoveVisibleWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "data", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "node", "", "visitNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitQualifiedAccessNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallExitNode;", "visitFunctionCallExitNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallExitNode;)V", "visitAnnotations", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "fir", "visitQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;"})
    private static final class RemoveVisibleWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public RemoveVisibleWrites(@NotNull Data data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this.data = data2;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
            this.visitAnnotations(node);
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            this.visitAnnotations(node);
            this.visitQualifiedAccess(node, node.getFir());
        }

        @Override
        public void visitFunctionCallExitNode(@NotNull FunctionCallExitNode node) {
            block0: {
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                Intrinsics.checkNotNullParameter(node, "node");
                this.visitAnnotations(node);
                FirFunctionCall firFunctionCall = node.getFir();
                FirImplicitInvokeCall firImplicitInvokeCall = firFunctionCall instanceof FirImplicitInvokeCall ? (FirImplicitInvokeCall)firFunctionCall : null;
                FirExpression firExpression = firImplicitInvokeCall != null ? firImplicitInvokeCall.getExplicitReceiver() : null;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) break block0;
                FirQualifiedAccessExpression it = firQualifiedAccessExpression;
                boolean bl = false;
                this.visitQualifiedAccess(node, it);
            }
        }

        private final void visitAnnotations(CFGNode<?> node) {
            block1: {
                Object obj = node.getFir();
                Object object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                if (object == null || (object = object.getAnnotations()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation call2 = (FirAnnotation)element$iv;
                    boolean bl = false;
                    call2.accept(new FirVisitorVoid(this, node){
                        final /* synthetic */ RemoveVisibleWrites this$0;
                        final /* synthetic */ CFGNode<?> $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                        }

                        public void visitElement(FirElement element) {
                            Intrinsics.checkNotNullParameter(element, "element");
                            if (element instanceof FirQualifiedAccessExpression) {
                                RemoveVisibleWrites.access$visitQualifiedAccess(this.this$0, this.$node, (FirQualifiedAccessExpression)element);
                            }
                            element.acceptChildren(this);
                        }
                    });
                }
            }
        }

        private final void visitQualifiedAccess(CFGNode<?> node, FirQualifiedAccessExpression fir) {
            block4: {
                FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(fir.getCalleeReference(), false, 1, null);
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol symbol = firPropertySymbol;
                if (symbol.getName().isSpecial()) {
                    return;
                }
                this.data.getVariablesWithoutReads().remove(symbol);
                PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> persistentMap = this.data.getWritesByNode().get(node);
                if (persistentMap == null || (persistentMap = (ImmutableCollection)persistentMap.values()) == null) break block4;
                Iterable $this$forEach$iv = (Iterable)((Object)persistentMap);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PersistentMap dataForLabel = (PersistentMap)element$iv;
                    boolean bl = false;
                    PersistentSet persistentSet = (PersistentSet)dataForLabel.get(symbol);
                    if (persistentSet == null) continue;
                    Iterable $this$forEach$iv2 = persistentSet;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CFGNode it = (CFGNode)element$iv2;
                        boolean bl2 = false;
                        Map<FirStatement, ControlFlowGraph> map2 = this.data.getUnreadWrites();
                        Object e = it.getFir();
                        TypeIntrinsics.asMutableMap(map2).remove(e);
                    }
                }
            }
        }

        public static final /* synthetic */ void access$visitQualifiedAccess(RemoveVisibleWrites $this, CFGNode node, FirQualifiedAccessExpression fir) {
            $this.visitQualifiedAccess(node, fir);
        }
    }
}

