/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\f\u0012\b\u0012\u0006*\u00020\u00190\u00190\u00188\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirMissingConstructorKeywordSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "", "isApplicable", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "checkPsi", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/KtPsiSourceElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkLightTree", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/KtLightSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "", "Lcom/intellij/psi/tree/IElementType;", "importantNodeTypes", "Ljava/util/Set;"})
public final class FirMissingConstructorKeywordSyntaxChecker
extends FirDeclarationSyntaxChecker<FirConstructor, KtDeclaration> {
    @NotNull
    public static final FirMissingConstructorKeywordSyntaxChecker INSTANCE = new FirMissingConstructorKeywordSyntaxChecker();
    @NotNull
    private static final Set<IElementType> importantNodeTypes;

    private FirMissingConstructorKeywordSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirConstructor element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return true;
    }

    @Override
    public void checkPsi(@NotNull FirConstructor element, @NotNull KtPsiSourceElement source, @NotNull KtDeclaration psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (psi instanceof KtConstructor && ((KtConstructor)psi).getModifierList() != null && ((KtConstructor)psi).getConstructorKeyword() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_CONSTRUCTOR_KEYWORD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkLightTree(@NotNull FirConstructor element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        void types$iv;
        void $this$forEachChildOfType_u24default$iv;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(source.getKind() instanceof KtRealSourceElementKind)) {
            return;
        }
        boolean hasModifiers = false;
        boolean hasConstructorKeyword = false;
        KtSourceElement ktSourceElement = source;
        Set<IElementType> set = importantNodeTypes;
        int depth$iv = 1;
        boolean reverse$iv = false;
        boolean $i$f$forEachChildOfType = false;
        if ($this$forEachChildOfType_u24default$iv instanceof KtPsiSourceElement) {
            PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
            boolean $i$f$forEachChildOfType2 = false;
            boolean $i$f$forEachChildOfType3 = false;
            Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
            List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                PsiElement it$iv$iv;
                object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = ((Pair)object).component1();
                int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                    void var20_28 = types$iv;
                    boolean bl = false;
                    IElementType iElementType = it$iv$iv.getNode().getElementType();
                    Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                    if (var20_28.contains(iElementType)) {
                        KtPsiSourceElement ktPsiSourceElement;
                        PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                        boolean bl2 = false;
                        PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                        KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                        boolean $i$f$toKtPsiSourceElement = false;
                        KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                        if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                            ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                        } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                            ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        KtSourceElement it = ktPsiSourceElement;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual(it.getElementType(), KtTokens.CONSTRUCTOR_KEYWORD)) {
                            hasConstructorKeyword = true;
                        } else {
                            hasModifiers = true;
                        }
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv) continue;
                it$iv$iv = (PsiElement)element$iv$iv$iv;
                boolean bl = false;
                List list = SequencesKt.toList(PsiUtilsKt.getAllChildren(it$iv$iv));
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf22 = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl4 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                while ($i$f$butIf22.hasNext()) {
                    Object element$iv$iv$iv$iv;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                    boolean bl5 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                }
            }
        } else {
            LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
            FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
            boolean $i$f$forEachChildOfType4 = false;
            boolean $i$f$forEachChildOfType5 = false;
            Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
            List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                LighterASTNode it$iv$iv;
                object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = ((Pair)object).component1();
                int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                    void var21_31 = types$iv;
                    boolean bl = false;
                    IElementType iElementType = it$iv$iv.getTokenType();
                    Intrinsics.checkNotNullExpressionValue(iElementType, "getTokenType(...)");
                    if (var21_31.contains(iElementType)) {
                        void $this$toKtLightSourceElement_u24default$iv$iv;
                        LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                        boolean bl6 = false;
                        LighterASTNode kind$iv$iv = it$iv;
                        FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                        KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                        int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                        int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                        boolean $i$f$toKtLightSourceElement = false;
                        KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                        boolean bl7 = false;
                        if (Intrinsics.areEqual(it.getElementType(), KtTokens.CONSTRUCTOR_KEYWORD)) {
                            hasConstructorKeyword = true;
                        } else {
                            hasModifiers = true;
                        }
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv) continue;
                it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                boolean bl = false;
                List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl8 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv$iv$iv2;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                    boolean bl9 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                }
            }
        }
        if (hasModifiers && !hasConstructorKeyword) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_CONSTRUCTOR_KEYWORD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.MODIFIER_LIST, KtTokens.CONSTRUCTOR_KEYWORD};
        importantNodeTypes = SetsKt.setOf(iElementTypeArray);
    }
}

