/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u001d\u001a\u0004\u0018\u00010\u0018*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u0004\u0018\u00010\u0018*\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010!\u001a\u0004\u0018\u00010\u0018*\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002\u00a2\u0006\u0004\b!\u0010 J'\u0010$\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b$\u0010%J/\u0010$\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b$\u0010&J\u0017\u0010)\u001a\u00020\t2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*J'\u0010+\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b+\u0010,R\u001e\u0010.\u001a\f\u0012\b\u0012\u0006*\u00020'0'0-8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "()V", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "", "isApplicable", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "checkPsi", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtPsiSourceElement;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkLightTree", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtLightSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lcom/intellij/lang/LighterASTNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker$Direction;", "direction", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "treeStructure", "getLeaf", "(Lcom/intellij/lang/LighterASTNode;Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker$Direction;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)Lcom/intellij/lang/LighterASTNode;", "prevLeaf", "(Lcom/intellij/lang/LighterASTNode;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)Lcom/intellij/lang/LighterASTNode;", "nextLeaf", "Lcom/intellij/psi/PsiElement;", "prefixOrSuffix", "checkLiteralPrefixOrSuffix", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "(Lcom/intellij/lang/LighterASTNode;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lcom/intellij/psi/tree/IElementType;", "elementType", "illegalLiteralPrefixOrSuffix", "(Lcom/intellij/psi/tree/IElementType;)Z", "report", "(Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "", "literalConstants", "Ljava/util/List;", "Direction"})
public final class FirPrefixAndSuffixSyntaxChecker
extends FirExpressionSyntaxChecker<FirStatement, KtExpression> {
    @NotNull
    public static final FirPrefixAndSuffixSyntaxChecker INSTANCE = new FirPrefixAndSuffixSyntaxChecker();
    @NotNull
    private static final List<IElementType> literalConstants;

    private FirPrefixAndSuffixSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirStatement element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return !(source.getKind() instanceof KtFakeSourceElementKind) && (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.STRING_TEMPLATE) || literalConstants.contains(source.getElementType()));
    }

    @Override
    public void checkPsi(@NotNull FirStatement element, @NotNull KtPsiSourceElement source, @NotNull KtExpression psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block1: {
            PsiElement it;
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(psi, "psi");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            PsiElement psiElement = PsiUtilsKt.prevLeaf$default(psi, false, 1, null);
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                INSTANCE.checkLiteralPrefixOrSuffix(it, context, reporter);
            }
            PsiElement psiElement2 = PsiUtilsKt.nextLeaf$default(psi, false, 1, null);
            if (psiElement2 == null) break block1;
            it = psiElement2;
            boolean bl = false;
            INSTANCE.checkLiteralPrefixOrSuffix(it, context, reporter);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirStatement element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block1: {
            LighterASTNode it;
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            LighterASTNode lighterASTNode = this.prevLeaf(source.getLighterASTNode(), source.getTreeStructure());
            if (lighterASTNode != null) {
                it = lighterASTNode;
                boolean bl = false;
                INSTANCE.checkLiteralPrefixOrSuffix(it, source, context, reporter);
            }
            lighterASTNode = this.nextLeaf(source.getLighterASTNode(), source.getTreeStructure());
            if (lighterASTNode == null) break block1;
            it = lighterASTNode;
            boolean bl = false;
            INSTANCE.checkLiteralPrefixOrSuffix(it, source, context, reporter);
        }
    }

    private final LighterASTNode getLeaf(LighterASTNode $this$getLeaf, Direction direction, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        LighterASTNode lighterASTNode;
        LighterASTNode lighterASTNode2 = treeStructure.getParent($this$getLeaf);
        if (lighterASTNode2 == null) {
            return null;
        }
        LighterASTNode parent2 = lighterASTNode2;
        List<LighterASTNode> children2 = LightTreeUtilsKt.getChildren(parent2, treeStructure);
        int index2 = children2.indexOf($this$getLeaf);
        LighterASTNode leaf = CollectionsKt.getOrNull(children2, index2 - direction.getOffset());
        if (leaf == null && Intrinsics.areEqual(parent2.getTokenType(), KtNodeTypes.BINARY_EXPRESSION)) {
            lighterASTNode = this.getLeaf(parent2, direction, treeStructure);
        } else {
            if (leaf == null) {
                return null;
            }
            LighterASTNode result2 = leaf;
            List<LighterASTNode> resultChildren = LightTreeUtilsKt.getChildren(leaf, treeStructure);
            while (!((Collection)resultChildren).isEmpty()) {
                result2 = direction == Direction.PREVIOUS ? CollectionsKt.first(resultChildren) : CollectionsKt.last(resultChildren);
                resultChildren = LightTreeUtilsKt.getChildren(result2, treeStructure);
            }
            lighterASTNode = result2;
        }
        return lighterASTNode;
    }

    private final LighterASTNode prevLeaf(LighterASTNode $this$prevLeaf, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        return this.getLeaf($this$prevLeaf, Direction.PREVIOUS, treeStructure);
    }

    private final LighterASTNode nextLeaf(LighterASTNode $this$nextLeaf, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        return this.getLeaf($this$nextLeaf, Direction.NEXT, treeStructure);
    }

    private final void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, CheckerContext context, DiagnosticReporter reporter) {
        IElementType iElementType = prefixOrSuffix.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        if (this.illegalLiteralPrefixOrSuffix(iElementType)) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement $this$toKtPsiSourceElement_u24default$iv = prefixOrSuffix;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.report(ktPsiSourceElement, context, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLiteralPrefixOrSuffix(LighterASTNode prefixOrSuffix, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        IElementType iElementType = prefixOrSuffix.getTokenType();
        if (iElementType == null) {
            return;
        }
        IElementType elementType = iElementType;
        if (this.illegalLiteralPrefixOrSuffix(elementType)) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode = prefixOrSuffix;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = source.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            this.report(new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv), context, reporter);
        }
    }

    private final boolean illegalLiteralPrefixOrSuffix(IElementType elementType) {
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    private final void report(KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"literal prefixes and suffixes", (DiagnosticContext)context, null, 16, null);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.CHARACTER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT, KtNodeTypes.INTEGER_CONSTANT};
        literalConstants = CollectionsKt.listOf(iElementTypeArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker$Direction;", "", "", "offset", "<init>", "(Ljava/lang/String;II)V", "I", "getOffset", "()I", "PREVIOUS", "NEXT"})
    private static final class Direction
    extends Enum<Direction> {
        private final int offset;
        public static final /* enum */ Direction PREVIOUS = new Direction(-1);
        public static final /* enum */ Direction NEXT = new Direction(1);
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Direction(int offset) {
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value2) {
            return Enum.valueOf(Direction.class, value2);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.PREVIOUS, Direction.NEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

