/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\u00068\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "checkSettings", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "context", "checkAndCommitReportsOn", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;"})
public abstract class AbstractDiagnosticCollectorComponent
extends FirVisitor<Unit, CheckerContext> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final DiagnosticReporter reporter;

    public AbstractDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.session = session;
        this.reporter = reporter;
    }

    @NotNull
    protected final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final DiagnosticReporter getReporter() {
        return this.reporter;
    }

    @Override
    public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data2, "data");
    }

    public void checkSettings(@NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
    }

    protected final void checkAndCommitReportsOn(@NotNull FirElement element, @Nullable DiagnosticContext context) {
        Intrinsics.checkNotNullParameter(element, "element");
        KtSourceElement ktSourceElement = element.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        this.reporter.checkAndCommitReportsOn(source, context);
    }
}

