/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001?B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010'\u001a\u00020\u00112\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010+\u001a\u00020\u00112\u0006\u0010*\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010/\u001a\u00020\u00112\u0006\u0010.\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00103\u001a\u00020\u00112\u0006\u00102\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00107\u001a\u00020\u00112\u0006\u00106\u001a\u0002052\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b7\u00108R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020:098\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020=098\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010<"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "declarationCheckers", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "mppKind", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirControlFlowGraphOwner;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "analyze", "(Lorg/jetbrains/kotlin/fir/declarations/FirControlFlowGraphOwner;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "visitFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "script", "visitScript", "(Lorg/jetbrains/kotlin/fir/declarations/FirScript;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "visitRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "anonymousObject", "visitAnonymousObject", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "visitFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "visitSimpleFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "propertyAccessor", "visitPropertyAccessor", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "visitConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "cfaCheckers", "Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "variableAssignmentCheckers", "LocalPropertyCollector"})
public final class ControlFlowAnalysisDiagnosticComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    private final Set<FirControlFlowChecker> cfaCheckers;
    @NotNull
    private final Set<AbstractFirPropertyInitializationChecker> variableAssignmentCheckers;

    public ControlFlowAnalysisDiagnosticComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter, @NotNull DeclarationCheckers declarationCheckers) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declarationCheckers, "declarationCheckers");
        super(session, reporter);
        this.cfaCheckers = declarationCheckers.getControlFlowAnalyserCheckers();
        this.variableAssignmentCheckers = declarationCheckers.getVariableAssignmentCfaBasedCheckers();
    }

    public ControlFlowAnalysisDiagnosticComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter, @NotNull MppCheckerKind mppKind) {
        DeclarationCheckers declarationCheckers;
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter((Object)mppKind, "mppKind");
        switch (WhenMappings.$EnumSwitchMapping$0[mppKind.ordinal()]) {
            case 1: {
                declarationCheckers = CheckersComponentKt.getCheckersComponent(session).getCommonDeclarationCheckers();
                break;
            }
            case 2: {
                declarationCheckers = CheckersComponentKt.getCheckersComponent(session).getPlatformDeclarationCheckers();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this(session, reporter, declarationCheckers);
    }

    private final void analyze(FirControlFlowGraphOwner declaration, CheckerContext context) {
        Object object = declaration.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        if (((ControlFlowGraph)graph2).isSubGraph()) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze((ControlFlowGraph)graph2, this.getReporter(), context);
        }
        LocalPropertyCollector $this$analyze_u24lambda_u241 = $i$f$forEach = new LocalPropertyCollector();
        boolean bl = false;
        declaration.acceptChildren($this$analyze_u24lambda_u241, CollectionsKt.toSet((Iterable)((ControlFlowGraph)graph2).getSubGraphs()));
        LocalPropertyCollector collector2 = $i$f$forEach;
        Set<FirPropertySymbol> properties2 = collector2.getProperties();
        if (!((Collection)properties2).isEmpty()) {
            PropertyInitializationInfoData data2 = new PropertyInitializationInfoData(properties2, collector2.getConditionallyInitializedProperties(), null, (ControlFlowGraph)graph2);
            Iterable $this$forEach$iv2 = this.variableAssignmentCheckers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AbstractFirPropertyInitializationChecker it = (AbstractFirPropertyInitializationChecker)element$iv;
                boolean bl2 = false;
                it.analyze(data2, this.getReporter(), context);
            }
        }
    }

    @Override
    public void visitFile(@NotNull FirFile file2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(file2, data2);
    }

    @Override
    public void visitScript(@NotNull FirScript script, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(script, data2);
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(regularClass, data2);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(anonymousObject, data2);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(property, data2);
    }

    @Override
    public void visitFunction(@NotNull FirFunction function2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(function2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(simpleFunction, data2);
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(propertyAccessor, data2);
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(constructor, data2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001f\u0010\u001dR,\u0010#\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180!0 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u00188\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent$LocalPropertyCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedAccessExpression", "visitQualifiedAccessExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "doWhileLoop", "visitDoWhileLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;Ljava/util/Set;)V", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "properties", "Ljava/util/Set;", "getProperties", "()Ljava/util/Set;", "conditionallyInitializedProperties", "getConditionallyInitializedProperties", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "doWhileLoopProperties", "Lkotlin/collections/ArrayDeque;", "insideDoWhileConditions"})
    private static final class LocalPropertyCollector
    extends FirDefaultVisitor<Unit, Set<? extends ControlFlowGraph>> {
        @NotNull
        private final Set<FirPropertySymbol> properties = new LinkedHashSet();
        @NotNull
        private final Set<FirPropertySymbol> conditionallyInitializedProperties = new LinkedHashSet();
        @NotNull
        private final ArrayDeque<Pair<FirLoop, Set<FirPropertySymbol>>> doWhileLoopProperties = new ArrayDeque();
        @NotNull
        private final Set<FirLoop> insideDoWhileConditions = new LinkedHashSet();

        @NotNull
        public final Set<FirPropertySymbol> getProperties() {
            return this.properties;
        }

        @NotNull
        public final Set<FirPropertySymbol> getConditionallyInitializedProperties() {
            return this.conditionallyInitializedProperties;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Set<ControlFlowGraph> data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (element instanceof FirControlFlowGraphOwner) {
                ControlFlowGraph elementGraph;
                FirControlFlowGraphReference firControlFlowGraphReference = ((FirControlFlowGraphOwner)element).getControlFlowGraphReference();
                ControlFlowGraph controlFlowGraph = elementGraph = firControlFlowGraphReference != null ? FirControlFlowGraphReferenceImplKt.getControlFlowGraph(firControlFlowGraphReference) : null;
                if (elementGraph == null) {
                    element.acceptChildren(this, data2);
                } else if (data2.contains(elementGraph)) {
                    element.acceptChildren(this, CollectionsKt.toSet((Iterable)elementGraph.getSubGraphs()));
                }
            } else {
                element.acceptChildren(this, data2);
            }
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @NotNull Set<ControlFlowGraph> data2) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!property.isLocal() || Intrinsics.areEqual(property.getOrigin(), FirDeclarationOrigin.ScriptCustomization.Parameter.INSTANCE) || Intrinsics.areEqual(property.getOrigin(), FirDeclarationOrigin.ScriptCustomization.ParameterFromBaseClass.INSTANCE)) {
                this.visitElement((FirElement)property, data2);
                return;
            }
            FirPropertySymbol symbol = property.getSymbol();
            this.properties.add(symbol);
            Pair<FirLoop, Set<FirPropertySymbol>> pair = this.doWhileLoopProperties.lastOrNull();
            if (pair != null && (pair = pair.getSecond()) != null) {
                pair.add(symbol);
            }
            this.visitElement((FirElement)property, data2);
        }

        @Override
        public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull Set<ControlFlowGraph> data2) {
            Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!((Collection)this.insideDoWhileConditions).isEmpty()) {
                boolean bl;
                FirPropertySymbol symbol;
                block6: {
                    FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(qualifiedAccessExpression.getCalleeReference(), false, 1, null);
                    if (firPropertySymbol == null) {
                        return;
                    }
                    symbol = firPropertySymbol;
                    Iterable $this$any$iv = this.doWhileLoopProperties;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!(this.insideDoWhileConditions.contains(it.getFirst()) && ((Set)it.getSecond()).contains(symbol))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.conditionallyInitializedProperties.add(symbol);
                }
            }
            this.visitElement((FirElement)qualifiedAccessExpression, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull Set<ControlFlowGraph> data2) {
            Intrinsics.checkNotNullParameter(doWhileLoop, "doWhileLoop");
            Intrinsics.checkNotNullParameter(data2, "data");
            this.doWhileLoopProperties.addLast(TuplesKt.to(doWhileLoop, (Set)new LinkedHashSet()));
            doWhileLoop.getBlock().accept(this, data2);
            this.insideDoWhileConditions.add(doWhileLoop);
            doWhileLoop.getCondition().accept(this, data2);
            this.insideDoWhileConditions.remove(doWhileLoop);
            this.doWhileLoopProperties.removeLast();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MppCheckerKind.values().length];
            try {
                nArray[MppCheckerKind.Common.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MppCheckerKind.Platform.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

