/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeContextParameterWithDefaultValue;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 T2\u00020\u0001:\u0001TB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0014\u001a\u00020\u0013*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0013*\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u001b\u001a\u00020\u0013*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010'\u001a\u00020\f2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010+\u001a\u00020\f2\u0006\u0010*\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b+\u0010,J'\u00100\u001a\u00020\f2\u0006\u0010.\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\u00020\u0013*\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b2\u00103J\u001f\u00106\u001a\u00020\f2\u0006\u00105\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b6\u00107J\u001f\u0010:\u001a\u00020\f2\u0006\u00109\u001a\u0002082\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010>\u001a\u00020\f2\u0006\u0010=\u001a\u00020<2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b>\u0010?J\u001f\u0010B\u001a\u00020\f2\u0006\u0010A\u001a\u00020@2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bB\u0010CJ\u0013\u0010E\u001a\u00020\u0013*\u00020DH\u0002\u00a2\u0006\u0004\bE\u0010FJ\u001f\u0010I\u001a\u00020\f2\u0006\u0010H\u001a\u00020G2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u001f\u0010M\u001a\u00020\f2\u0006\u0010L\u001a\u00020K2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bM\u0010NJ5\u0010R\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010P\u001a\u0004\u0018\u00010O2\u0006\u0010/\u001a\u00020\n2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010OH\u0002\u00a2\u0006\u0004\bR\u0010S"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "errorLoop", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "data", "", "visitErrorLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "errorTypeRef", "visitErrorTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "", "isLambdaReturnTypeRefThatDoesntNeedReporting", "(Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "hasExpandedTypeAliasDeclarationSiteError", "(Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostic", "hasDiagnostic", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)Z", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolvedTypeRef", "visitResolvedTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "errorAnnotationCall", "visitErrorAnnotationCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "errorNamedReference", "visitErrorNamedReference", "(Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/references/FirResolvedErrorReference;", "resolvedErrorReference", "visitResolvedErrorReference", "(Lorg/jetbrains/kotlin/fir/references/FirResolvedErrorReference;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "reference", "context", "processErrorReference", "(Lorg/jetbrains/kotlin/fir/references/FirNamedReference;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "cannotBeResolved", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "errorExpression", "visitErrorExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "errorFunction", "visitErrorFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "errorProperty", "visitErrorProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "errorResolvedQualifier", "visitErrorResolvedQualifier", "(Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "hasErrorOrParentWithError", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "errorPrimaryConstructor", "visitErrorPrimaryConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/references/FirThisReference;", "thisReference", "visitThisReference", "(Lorg/jetbrains/kotlin/fir/references/FirThisReference;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "callOrAssignmentSource", "reportFirDiagnostic", "(Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;)V", "Companion"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        super(session, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorLoop, "errorLoop");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement source = errorLoop.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (this.isLambdaReturnTypeRefThatDoesntNeedReporting(errorTypeRef, data2)) {
            return;
        }
        if (this.hasExpandedTypeAliasDeclarationSiteError(errorTypeRef)) {
            return;
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), errorTypeRef.getSource(), data2, null, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLambdaReturnTypeRefThatDoesntNeedReporting(FirErrorTypeRef $this$isLambdaReturnTypeRefThatDoesntNeedReporting, CheckerContext data2) {
        boolean bl;
        boolean bl2;
        KtSourceElement ktSourceElement = $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ImplicitFunctionReturnType.INSTANCE)) {
            return false;
        }
        FirDeclaration containingDeclaration = CollectionsKt.lastOrNull(data2.getContainingDeclarations());
        if (!(containingDeclaration instanceof FirAnonymousFunction)) return false;
        if (!Intrinsics.areEqual(((FirAnonymousFunction)containingDeclaration).getReturnTypeRef(), $this$isLambdaReturnTypeRefThatDoesntNeedReporting)) {
            return false;
        }
        Iterable $this$any$iv = FirHelpersKt.getReturnedExpressions((FirAnonymousFunction)containingDeclaration);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirExpression firExpression = (FirExpression)element$iv;
                boolean bl3 = false;
                if (!this.hasDiagnostic(firExpression, $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getDiagnostic())) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = data2.getCallsOrAssignments();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            FirStatement firStatement = (FirStatement)element$iv;
            boolean bl4 = false;
            if (firStatement instanceof FirExpression && this.hasDiagnostic((FirExpression)firStatement, $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getDiagnostic())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean hasExpandedTypeAliasDeclarationSiteError(FirErrorTypeRef $this$hasExpandedTypeAliasDeclarationSiteError) {
        ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible($this$hasExpandedTypeAliasDeclarationSiteError.getConeType());
        ConeErrorType coneErrorType = coneRigidType instanceof ConeErrorType ? (ConeErrorType)coneRigidType : null;
        if (coneErrorType == null) {
            return false;
        }
        ConeErrorType lowerBound = coneErrorType;
        if (!Intrinsics.areEqual(lowerBound.getDiagnostic(), $this$hasExpandedTypeAliasDeclarationSiteError.getDiagnostic())) {
            return false;
        }
        return AbbreviatedTypeAttributeKt.getAbbreviatedType(lowerBound) != null;
    }

    private final boolean hasDiagnostic(FirExpression $this$hasDiagnostic, ConeDiagnostic diagnostic) {
        Object object = FirTypeUtilsKt.getResolvedType($this$hasDiagnostic);
        ConeErrorType coneErrorType = object instanceof ConeErrorType ? (ConeErrorType)object : null;
        if (Intrinsics.areEqual(coneErrorType != null ? coneErrorType.getDiagnostic() : null, diagnostic)) {
            return true;
        }
        object = ReferenceUtilsKt.toReference($this$hasDiagnostic, this.getSession());
        FirDiagnosticHolder firDiagnosticHolder = object instanceof FirDiagnosticHolder ? (FirDiagnosticHolder)object : null;
        return Intrinsics.areEqual(firDiagnosticHolder != null ? firDiagnosticHolder.getDiagnostic() : null, diagnostic);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        Intrinsics.checkNotNullParameter(data2, "data");
        boolean bl2 = bl = !(resolvedTypeRef.getConeType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getConeType());
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorAnnotationCall, "errorAnnotationCall");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement source = errorAnnotationCall.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorAnnotationCall.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorNamedReference, "errorNamedReference");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.processErrorReference(errorNamedReference, errorNamedReference.getDiagnostic(), data2);
    }

    @Override
    public void visitResolvedErrorReference(@NotNull FirResolvedErrorReference resolvedErrorReference, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(resolvedErrorReference, "resolvedErrorReference");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.processErrorReference(resolvedErrorReference, resolvedErrorReference.getDiagnostic(), data2);
    }

    private final void processErrorReference(FirNamedReference reference, ConeDiagnostic diagnostic, CheckerContext context) {
        FirStatement firStatement;
        KtSourceElement source = reference.getSource();
        FirStatement firStatement2 = CollectionsKt.lastOrNull(context.getCallsOrAssignments());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            firStatement = Intrinsics.areEqual(ReferenceUtilsKt.toReference(it, this.getSession()), reference) ? firStatement3 : null;
        } else {
            firStatement = null;
        }
        FirStatement callOrAssignment = firStatement;
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.ANNOTATION_ENTRY) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        if (callOrAssignment instanceof FirQualifiedAccessExpression && (this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExplicitReceiver()))) {
            return;
        }
        KtSourceElement ktSourceElement3 = source;
        source = ktSourceElement3 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(ktSourceElement3, context) : null;
        FirStatement firStatement4 = callOrAssignment;
        this.reportFirDiagnostic(diagnostic, source, context, firStatement4 != null ? firStatement4.getSource() : null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        ConeDiagnostic diagnostic;
        Object object = $this$cannotBeResolved;
        ConeRigidType coneRigidType = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)object) : null;
        ConeErrorType coneErrorType = coneRigidType instanceof ConeErrorType ? (ConeErrorType)coneRigidType : null;
        ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        return diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeInstanceAccessBeforeSuperCall || diagnostic instanceof ConeAmbiguousSuper ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.AmbiguousLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorExpression, "errorExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement source = errorExpression.getSource();
        ConeDiagnostic diagnostic = errorExpression.getDiagnostic();
        if (source == null) {
            if (diagnostic instanceof ConeSyntaxDiagnostic) {
                return;
            }
            if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ExpressionExpected) {
                return;
            }
        }
        if (Intrinsics.areEqual(diagnostic, ConeContextParameterWithDefaultValue.INSTANCE)) {
            List<FirDeclaration> it = data2.getContainingDeclarations();
            boolean bl = false;
            if (CollectionsKt.getOrNull(it, CollectionsKt.getLastIndex(it) - 1) instanceof FirPrimaryConstructor) {
                return;
            }
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data2, null, 8, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorFunction, "errorFunction");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement source = errorFunction.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorProperty, "errorProperty");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement source = errorProperty.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorProperty.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
        Intrinsics.checkNotNullParameter(data2, "data");
        FirResolvedQualifier firResolvedQualifier = errorResolvedQualifier.getExplicitParent();
        boolean bl = firResolvedQualifier != null ? this.hasErrorOrParentWithError(firResolvedQualifier) : false;
        if (bl) {
            return;
        }
        KtSourceElement source = errorResolvedQualifier.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, data2, null, 8, null);
    }

    private final boolean hasErrorOrParentWithError(FirResolvedQualifier $this$hasErrorOrParentWithError) {
        if ($this$hasErrorOrParentWithError instanceof FirErrorResolvedQualifier) {
            return true;
        }
        FirResolvedQualifier firResolvedQualifier = $this$hasErrorOrParentWithError.getExplicitParent();
        return firResolvedQualifier != null ? this.hasErrorOrParentWithError(firResolvedQualifier) : false;
    }

    @Override
    public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
        Intrinsics.checkNotNullParameter(data2, "data");
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorPrimaryConstructor.getDiagnostic(), errorPrimaryConstructor.getSource(), data2, null, 8, null);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(thisReference, "thisReference");
        Intrinsics.checkNotNullParameter(data2, "data");
        ConeDiagnostic coneDiagnostic = thisReference.getDiagnostic();
        if (coneDiagnostic == null) {
            return;
        }
        ConeDiagnostic diagnostic = coneDiagnostic;
        KtSourceElement ktSourceElement = thisReference.getSource();
        if (ktSourceElement == null) {
            FirElement firElement = CollectionsKt.getOrNull(data2.getContainingElements(), 1);
            ktSourceElement = firElement != null ? firElement.getSource() : null;
        }
        KtSourceElement source = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data2, null, 8, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context, KtSourceElement callOrAssignmentSource) {
        Companion.reportFirDiagnostic$checkers(diagnostic, source, context, this.getSession(), this.getReporter(), callOrAssignmentSource);
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "callOrAssignmentSource", "", "reportFirDiagnostic$checkers", "(Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "reportFirDiagnostic"})
    public static final class Companion {
        private Companion() {
        }

        public final void reportFirDiagnostic$checkers(@NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull CheckerContext context, @NotNull FirSession session, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement callOrAssignmentSource) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
                    Intrinsics.checkNotNullParameter(context, "context");
                    Intrinsics.checkNotNullParameter(session, "session");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    KtSourceElement ktSourceElement = source;
                    if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
                        return;
                    }
                    KtSourceElement ktSourceElement2 = source;
                    if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
                        return;
                    }
                    KtSourceElement ktSourceElement3 = source;
                    if (Intrinsics.areEqual(ktSourceElement3 != null ? ktSourceElement3.getKind() : null, KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) break block7;
                    KtSourceElement ktSourceElement4 = source;
                    if (!Intrinsics.areEqual(ktSourceElement4 != null ? ktSourceElement4.getKind() : null, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block8;
                }
                return;
            }
            KtSourceElement ktSourceElement = source;
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredPrefixSecondGetReference) {
                return;
            }
            for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, session, source, callOrAssignmentSource)) {
                reporter.report(coneDiagnostic, context);
            }
        }

        public static /* synthetic */ void reportFirDiagnostic$checkers$default(Companion companion, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, FirSession firSession, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement2, int n, Object object) {
            if ((n & 8) != 0) {
                firSession = checkerContext.getSession();
            }
            if ((n & 0x20) != 0) {
                ktSourceElement2 = null;
            }
            companion.reportFirDiagnostic$checkers(coneDiagnostic, ktSourceElement, checkerContext, firSession, diagnosticReporter, ktSourceElement2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

