/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\r\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0013\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/MultiplatformDiagnosticRenderingMode;", "", "<init>", "()V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "", "newLine", "(Ljava/lang/StringBuilder;)V", "", "Lkotlin/Function0;", "elements", "renderList", "(Ljava/lang/StringBuilder;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "", "indent", "renderSymbol", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/lang/String;)V"})
public class MultiplatformDiagnosticRenderingMode {
    public void newLine(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append('\n');
    }

    public void renderList(@NotNull StringBuilder sb, @NotNull List<? extends Function0<Unit>> elements) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(elements, "elements");
        sb.append('\n');
        for (Function0<Unit> function0 : elements) {
            function0.invoke();
        }
    }

    public void renderSymbol(@NotNull StringBuilder sb, @NotNull FirBasedSymbol<?> symbol, @NotNull String indent) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(indent, "indent");
        sb.append(indent);
        sb.append("    ");
        sb.append(FirDiagnosticRenderers.INSTANCE.getSYMBOL().render(symbol)).append('\n');
    }
}

