/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

public abstract class FirJsAbstractNativeAnnotationChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    private final ClassId requiredAnnotation;

    public FirJsAbstractNativeAnnotationChecker(@NotNull ClassId requiredAnnotation) {
        Intrinsics.checkNotNullParameter(requiredAnnotation, "requiredAnnotation");
        super(MppCheckerKind.Common);
        this.requiredAnnotation = requiredAnnotation;
    }

    protected final boolean hasRequiredAnnotation(@NotNull FirFunction $this$hasRequiredAnnotation, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$hasRequiredAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirAnnotationUtilsKt.hasAnnotation($this$hasRequiredAnnotation, this.requiredAnnotation, context.getSession());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        v0 = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, this.requiredAnnotation, context.getSession());
        if (v0 == null) {
            return;
        }
        annotation = v0;
        if (FirHelpersKt.isTopLevel(context)) ** GOTO lbl-1000
        $this$visibility$iv = declaration;
        $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isMember = v1;
        isExtension = FirDeclarationUtilKt.isExtension(declaration);
        if (isMember && (isExtension || !FirJsHelpersKt.isNativeObject((FirBasedSymbol)declaration.getSymbol(), context)) || !isMember && !isExtension) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_ANNOTATIONS_ALLOWED_ONLY_ON_MEMBER_OR_EXTENSION_FUN(), (Object)FirTypeUtilsKt.getResolvedType(annotation), (DiagnosticContext)context, null, 16, null);
        }
    }
}

