/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeAnnotationChecker;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

public abstract class FirJsAbstractNativeIndexerChecker
extends FirJsAbstractNativeAnnotationChecker {
    @NotNull
    private final String indexerKind;
    private final int requiredParametersCount;

    public FirJsAbstractNativeIndexerChecker(@NotNull ClassId requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkNotNullParameter(requiredAnnotation, "requiredAnnotation");
        Intrinsics.checkNotNullParameter(indexerKind, "indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirValueParameter firstParameterDeclaration;
        ConeKotlinType firstParameter;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        super.check(declaration, context, reporter);
        List<FirValueParameter> parameters2 = declaration.getValueParameters();
        BuiltinTypes builtIns = context.getSession().getBuiltinTypes();
        if (!((Collection)parameters2).isEmpty() && !((firstParameter = FirTypeUtilsKt.getConeType((firstParameterDeclaration = CollectionsKt.first(parameters2)).getReturnTypeRef())) instanceof ConeErrorType) && !ConeBuiltinTypeUtilsKt.isString(firstParameter) && !TypeUtilsKt.isSubtypeOf$default(firstParameter, builtIns.getNumberType().getConeType(), context.getSession(), false, 4, null)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstParameterDeclaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER(), (Object)this.indexerKind, (DiagnosticContext)context, null, 16, null);
        }
        if (parameters2.size() != this.requiredParametersCount) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_INDEXER_WRONG_PARAMETER_COUNT(), (Object)this.requiredParametersCount, (Object)this.indexerKind, (DiagnosticContext)context, null, 32, null);
        }
        for (FirValueParameter parameter : parameters2) {
            if (parameter.getDefaultValue() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirJsErrors.INSTANCE.getNATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS(), (Object)this.indexerKind, (DiagnosticContext)context, null, 16, null);
        }
    }
}

