/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001b\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0013R\u0018\u0010\u001f\u001a\u00020\b*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010$\u001a\u0004\u0018\u00010!*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isNativeOrEffectivelyExternal", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "reportExternalEnum", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "additionalCheck", "Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "isDefinedExternallyCallableId", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "hasExternalLikeAnnotations", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "checkEnumEntry", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "allowsReporting", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "varargElementType"})
public final class FirJsExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
        super(true);
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirJsHelpersKt.isNativeObject(symbol, session);
    }

    @Override
    public void reportExternalEnum(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), (DiagnosticContext)context, null, 8, null);
    }

    @Override
    public void additionalCheck(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context, null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration, reporter, context, valueClassInExternalDiagnostic, arg_0 -> FirJsExternalChecker.additionalCheck$lambda$1(context, arg_0));
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration, reporter, context, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), additionalCheck.2.INSTANCE);
        }
        this.checkEnumEntry(declaration, context, reporter);
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        return Intrinsics.areEqual(callableId, JsStandardClassIds.Callables.JsDefinedExternally);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsNative, session);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual($this$allowsReporting.getKind(), KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = ArraysKt.firstOrNull(FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    private final void checkEnumEntry(FirDeclaration $this$checkEnumEntry, CheckerContext context, DiagnosticReporter reporter) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression == null) break block1;
            FirExpression it = firExpression;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, CheckerContext $context, ConeKotlinType type2, KtSourceElement elementToReport) {
        if ($condition.invoke(type2).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, DiagnosticReporter $reporter, CheckerContext $context, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl2 = false;
                FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = ktParam = parameter.getSource();
            boolean bl3 = ktSourceElement3 != null ? INSTANCE.getAllowsReporting(ktSourceElement3) : false;
            if (!bl3) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, typeToCheck, ktParam);
        }
    }

    private static final boolean additionalCheck$lambda$1(CheckerContext $context, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FirHelpersKt.isValueClass(it, $context.getSession());
    }
}

