/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public final class FirJsNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsNameChecker INSTANCE = new FirJsNameChecker();

    private FirJsNameChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        KtSourceElement jsNameSource;
        block21: {
            block20: {
                boolean $i$f$isOverride;
                Object $this$isOverride$iv;
                block19: {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(context, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (declaration instanceof FirProperty) {
                        int namedAccessorCount;
                        int n;
                        FirPropertyAccessorSymbol[] firPropertyAccessorSymbolArray = new FirPropertyAccessorSymbol[2];
                        FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
                        firPropertyAccessorSymbolArray[0] = firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
                        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
                        firPropertyAccessorSymbolArray[1] = firPropertyAccessor2 != null ? firPropertyAccessor2.getSymbol() : null;
                        List<FirPropertyAccessorSymbol> accessors = CollectionsKt.listOfNotNull(firPropertyAccessorSymbolArray);
                        Iterable $this$count$iv = accessors;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                FirPropertyAccessorSymbol it = (FirPropertyAccessorSymbol)element$iv;
                                boolean bl = false;
                                if (!(FirJsHelpersKt.getJsName(it, context.getSession()) != null) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = namedAccessorCount = count$iv;
                        }
                        if (namedAccessorCount > 0 && namedAccessorCount < accessors.size()) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getJS_NAME_IS_NOT_ON_ALL_ACCESSORS(), (DiagnosticContext)context, null, 8, null);
                        }
                    }
                    FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JsStandardClassIds.Annotations.JsName, context.getSession());
                    if (firAnnotation == null) {
                        return;
                    }
                    FirAnnotation jsName = firAnnotation;
                    KtSourceElement ktSourceElement = jsName.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = jsNameSource = declaration.getSource();
                    }
                    if (FirHelpersKt.getAnnotationStringParameter(declaration.getSymbol(), JsStandardClassIds.Annotations.JsNative, context.getSession()) != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_NAMED_NATIVE(), (DiagnosticContext)context, null, 8, null);
                    }
                    if (!(declaration instanceof FirCallableDeclaration)) break block19;
                    $this$isOverride$iv = (FirMemberDeclaration)declaration;
                    $i$f$isOverride = false;
                    if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) break block20;
                }
                if (!(declaration instanceof FirPropertyAccessor)) break block21;
                $this$isOverride$iv = ((FirPropertyAccessor)declaration).getPropertySymbol();
                $i$f$isOverride = false;
                if (!((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) break block21;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
        }
        if ((firDeclaration = declaration) instanceof FirConstructor) {
            if (((FirConstructor)declaration).isPrimary()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            FirPropertySymbol property = ((FirPropertyAccessor)declaration).getPropertySymbol();
            if (FirJsHelpersKt.getJsName(property, context.getSession()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_ACCESSOR_AND_PROPERTY(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (firDeclaration instanceof FirProperty && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

