/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsStaticChecker INSTANCE = new FirJsStaticChecker();

    private FirJsStaticChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            FirAnnotation declarationAnnotation = this.findAnnotation(declaration, JsStandardClassIds.Annotations.JsStatic, context.getSession());
            if (declarationAnnotation != null) {
                FirJsStaticChecker.checkAnnotated$default(this, declaration, context, reporter, declaration.getSource(), null, 16, null);
            }
            if (!(declaration instanceof FirProperty)) break block5;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
        }
    }

    private final void checkAnnotated(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> container = firClassLikeSymbol;
        if (!this.isCompanion(container) || this.containerIsInterface(container)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_NOT_IN_CLASS_COMPANION(), (DiagnosticContext)context, null, 8, null);
        }
        this.checkOverrideCannotBeStatic((FirMemberDeclaration)declaration, context, reporter, targetSource, outerProperty);
        this.checkStaticOnConst(declaration, context, reporter, targetSource);
        this.checkVisibility(declaration, context, reporter, targetSource);
    }

    static /* synthetic */ void checkAnnotated$default(FirJsStaticChecker firJsStaticChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirProperty firProperty, int n, Object object) {
        if ((n & 0x10) != 0) {
            firProperty = null;
        }
        firJsStaticChecker.checkAnnotated(firDeclaration, checkerContext, diagnosticReporter, ktSourceElement, firProperty);
    }

    private final void checkVisibility(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        Visibility visibility;
        Visibility visibility2;
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration instanceof FirProperty) {
            visibility2 = this.getMinimumVisibility((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            visibility2 = visibility = $this$visibility$iv.getStatus().getVisibility();
        }
        if (!Intrinsics.areEqual(visibility, Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_NON_PUBLIC_MEMBER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a, Visibility b) {
        Integer n = a.compareTo(b);
        if (n == null) {
            return a;
        }
        int difference = n;
        return difference > 0 ? b : a;
    }

    private final void checkOverrideCannotBeStatic(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        block6: {
            block5: {
                boolean bl;
                boolean $i$f$isOverride;
                FirMemberDeclaration $this$isOverride$iv;
                FirProperty firProperty = outerProperty;
                if (firProperty != null) {
                    $this$isOverride$iv = firProperty;
                    $i$f$isOverride = false;
                    bl = $this$isOverride$iv.getStatus().isOverride();
                } else {
                    bl = false;
                }
                if (bl) break block5;
                $this$isOverride$iv = declaration;
                $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block6;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkStaticOnConst(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        if (!(declaration instanceof FirProperty)) {
            return;
        }
        FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isConst = false;
        if ($this$isConst$iv.getStatus().isConst()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_CONST(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean containerIsInterface(FirClassLikeSymbol<?> $this$containerIsInterface) {
        boolean bl;
        Object object = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$containerIsInterface);
        if (object != null && (object = FirHelpersKt.getClassKind(object)) != null) {
            Object $this$isInterface$iv = object;
            boolean $i$f$isInterface = false;
            bl = $this$isInterface$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl = false;
        }
        return bl;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId, FirSession session) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()), session), classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        if (!FirAnnotationUtilsKt.hasAnnotation(it, JsStandardClassIds.Annotations.JsStatic, $context.getSession())) {
            return;
        }
        KtSourceElement ktSourceElement = it.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated(it, $context, $reporter, targetSource, $declaration instanceof FirProperty ? (FirProperty)$declaration : null);
    }
}

