/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.expression.FirJsDynamicCallCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class FirJsDynamicCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsDynamicCallChecker INSTANCE = new FirJsDynamicCallChecker();

    private FirJsDynamicCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        if (!(callee.getResolvedSymbol().getOrigin() instanceof FirDeclarationOrigin.DynamicScope)) {
            this.checkSpreadOperator(expression, context, reporter);
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(callee, false, 1, null);
        if (firCallableSymbol == null) {
            throw new IllegalStateException("Resolved call callee without a callable symbol".toString());
        }
        FirCallableSymbol symbol = firCallableSymbol;
        if (expression instanceof FirCall && this.isArrayAccessWithMultipleIndices((FirCall)((Object)expression), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCall)((Object)expression)).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"indexed access with more than one index", (DiagnosticContext)context, null, 16, null);
        } else if (expression instanceof FirFunctionCall && this.isInOperator((FirFunctionCall)expression)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`in` operation", (DiagnosticContext)context, null, 16, null);
        } else if (expression instanceof FirFunctionCall && this.isRangeOperator((FirFunctionCall)expression)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)('`' + (String)FirJsDynamicCallCheckerKt.access$getNameToOperator$p().get(symbol.getName()) + "` operation"), (DiagnosticContext)context, null, 16, null);
        } else if (expression instanceof FirComponentCall) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirComponentCall)expression).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`destructuring declaration", (DiagnosticContext)context, null, 16, null);
        } else {
            this.checkIdentifier(callee, reporter, context);
        }
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression instanceof FirCall ? (FirCall)((Object)expression) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getSPREAD_OPERATOR_IN_DYNAMIC_CALL(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
    }

    private final boolean isArrayAccessWithMultipleIndices(FirCall $this$isArrayAccessWithMultipleIndices, FirSession session) {
        FirReference firReference = ReferenceUtilsKt.toReference($this$isArrayAccessWithMultipleIndices, session);
        FirNamedReference firNamedReference = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (firNamedReference == null) {
            return false;
        }
        FirNamedReference callee = firNamedReference;
        KtSourceElement ktSourceElement = callee.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            return false;
        }
        FirCall $this$arguments$iv = $this$isArrayAccessWithMultipleIndices;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        Object object = firExpression instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)firExpression : null;
        if (object == null || (object = ((FirVarargArgumentsExpression)object).getArguments()) == null) {
            return false;
        }
        Object arguments2 = object;
        return Intrinsics.areEqual(callee.getName(), OperatorNameConventions.GET) && arguments2.size() >= 2 || Intrinsics.areEqual(callee.getName(), OperatorNameConventions.SET) && arguments2.size() >= 3;
    }

    private final boolean isInOperator(FirFunctionCall $this$isInOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isInOperator.getCalleeReference());
        return Intrinsics.areEqual(firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null, OperatorNameConventions.CONTAINS) && $this$isInOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final boolean isRangeOperator(FirFunctionCall $this$isRangeOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isRangeOperator.getCalleeReference());
        Name name = firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null;
        return (Intrinsics.areEqual(name, OperatorNameConventions.RANGE_TO) || Intrinsics.areEqual(name, OperatorNameConventions.RANGE_UNTIL)) && $this$isRangeOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final void checkSpreadOperator(FirQualifiedAccessExpression expression, CheckerContext context, DiagnosticReporter reporter) {
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression instanceof FirCall ? (FirCall)((Object)expression) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl = false;
                    if (!(FirTypeUtilsKt.getResolvedType(it) instanceof ConeDynamicType)) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"spread operator", (DiagnosticContext)context, null, 16, null);
                }
            }
        }
    }

    private final void checkIdentifier(FirResolvedNamedReference namedReference, DiagnosticReporter reporter, CheckerContext context) {
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        String string2 = namedReference.getName().getIdentifierOrNullIfSpecial();
        if (string2 == null) {
            return;
        }
        String name = string2;
        if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name), name)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)namedReference.getSource(), FirJsErrors.INSTANCE.getNAME_CONTAINS_ILLEGAL_CHARS(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

