/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.AnnotationsPosition;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponent;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ=\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u001b\u0010\u0019R \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019R&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u001e8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmAnnotationsPlatformSpecificSupportComponent;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotationsPlatformSpecificSupportComponent;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "symbolContainsRepeatableAnnotation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "propertyAnnotations", "backingFieldAnnotations", "Lorg/jetbrains/kotlin/fir/declarations/AnnotationsPosition;", "extractBackingFieldAnnotationsFromProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/declarations/AnnotationsPosition;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "requiredAnnotationsWithArguments", "Ljava/util/Set;", "getRequiredAnnotationsWithArguments", "()Ljava/util/Set;", "requiredAnnotations", "getRequiredAnnotations", "volatileAnnotations", "getVolatileAnnotations", "", "deprecationAnnotationsWithOverridesPropagation", "Ljava/util/Map;", "getDeprecationAnnotationsWithOverridesPropagation", "()Ljava/util/Map;"})
public final class FirJvmAnnotationsPlatformSpecificSupportComponent
extends FirAnnotationsPlatformSpecificSupportComponent {
    @NotNull
    public static final FirJvmAnnotationsPlatformSpecificSupportComponent INSTANCE = new FirJvmAnnotationsPlatformSpecificSupportComponent();
    @NotNull
    private static final Set<ClassId> requiredAnnotationsWithArguments;
    @NotNull
    private static final Set<ClassId> requiredAnnotations;
    @NotNull
    private static final Set<ClassId> volatileAnnotations;
    @NotNull
    private static final Map<ClassId, Boolean> deprecationAnnotationsWithOverridesPropagation;

    private FirJvmAnnotationsPlatformSpecificSupportComponent() {
    }

    @Override
    @NotNull
    public Set<ClassId> getRequiredAnnotationsWithArguments() {
        return requiredAnnotationsWithArguments;
    }

    @Override
    @NotNull
    public Set<ClassId> getRequiredAnnotations() {
        return requiredAnnotations;
    }

    @Override
    @NotNull
    public Set<ClassId> getVolatileAnnotations() {
        return volatileAnnotations;
    }

    @Override
    @NotNull
    public Map<ClassId, Boolean> getDeprecationAnnotationsWithOverridesPropagation() {
        return deprecationAnnotationsWithOverridesPropagation;
    }

    @Override
    public boolean symbolContainsRepeatableAnnotation(@NotNull FirClassLikeSymbol<?> symbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session, "session");
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol, StandardClassIds.Annotations.INSTANCE.getRepeatable(), session) != null) {
            return true;
        }
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), session) != null || FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol, JvmStandardClassIds.Annotations.INSTANCE.getJvmRepeatable(), session) != null) {
            return FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.RepeatableAnnotations) || FirRetentionAnnotationHelpersKt.getAnnotationRetention(symbol, session) == AnnotationRetention.SOURCE && symbol.getOrigin() instanceof FirDeclarationOrigin.Java;
        }
        return false;
    }

    @Override
    @Nullable
    public AnnotationsPosition extractBackingFieldAnnotationsFromProperty(@NotNull FirProperty property, @NotNull FirSession session, @NotNull List<? extends FirAnnotation> propertyAnnotations, @NotNull List<? extends FirAnnotation> backingFieldAnnotations) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(propertyAnnotations, "propertyAnnotations");
        Intrinsics.checkNotNullParameter(backingFieldAnnotations, "backingFieldAnnotations");
        if (propertyAnnotations.isEmpty() || property.getBackingField() == null) {
            return null;
        }
        Iterable $this$partition$iv = propertyAnnotations;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirAnnotation it = (FirAnnotation)element$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassIdSafe(it, session), JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated()) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List newBackingFieldAnnotations = pair.component1();
        List newPropertyAnnotations = pair.component2();
        if (newBackingFieldAnnotations.isEmpty()) {
            return null;
        }
        List list = CollectionsKt.plus((Collection)backingFieldAnnotations, (Iterable)newBackingFieldAnnotations);
        return new AnnotationsPosition(list, newPropertyAnnotations);
    }

    static {
        Object[] objectArray = new ClassId[]{StandardClassIds.Annotations.INSTANCE.getDeprecated(), StandardClassIds.Annotations.INSTANCE.getTarget(), JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), JvmStandardClassIds.Annotations.INSTANCE.getJvmName(), StandardClassIds.Annotations.INSTANCE.getDeprecatedSinceKotlin(), StandardClassIds.Annotations.INSTANCE.getSinceKotlin()};
        requiredAnnotationsWithArguments = SetsKt.setOf(objectArray);
        objectArray = new ClassId[]{JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), StandardClassIds.Annotations.INSTANCE.getWasExperimental(), JvmStandardClassIds.Annotations.INSTANCE.getJvmRecord()};
        requiredAnnotations = SetsKt.plus(INSTANCE.getRequiredAnnotationsWithArguments(), (Iterable)SetsKt.setOf(objectArray));
        objectArray = new ClassId[]{StandardClassIds.Annotations.INSTANCE.getVolatile(), JvmStandardClassIds.Annotations.INSTANCE.getJvmVolatile()};
        volatileAnnotations = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to(StandardClassIds.Annotations.INSTANCE.getDeprecated(), true), TuplesKt.to(JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), false), TuplesKt.to(StandardClassIds.Annotations.INSTANCE.getSinceKotlin(), true)};
        deprecationAnnotationsWithOverridesPropagation = MapsKt.mapOf(objectArray);
    }
}

