/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "namesPossibleForRenamedBuiltin", "", "Lorg/jetbrains/kotlin/name/Name;", "checkers.jvm"})
public final class FirAccidentalOverrideClashChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAccidentalOverrideClashChecker INSTANCE = new FirAccidentalOverrideClashChecker();
    @NotNull
    private static final Set<Name> namesPossibleForRenamedBuiltin = CollectionsKt.toSet((Iterable)SpecialGenericSignatures.Companion.getJVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP().values());

    private FirAccidentalOverrideClashChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        Name name = declaration.getName();
        boolean mayBeRenamedBuiltIn = namesPossibleForRenamedBuiltin.contains(name);
        boolean mayBeSameAsBuiltInWithErasedParameters = SpecialGenericSignatures.Companion.getSameAsBuiltinMethodWithErasedValueParameters(name);
        if (!mayBeRenamedBuiltIn && !mayBeSameAsBuiltInWithErasedParameters) {
            return;
        }
        FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(declaration);
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingClass = firRegularClass;
        Ref.BooleanRef reported = new Ref.BooleanRef();
        FirHelpersKt.unsubstitutedScope(containingClass, context).processFunctionsByName(name, arg_0 -> FirAccidentalOverrideClashChecker.check$lambda$0(reported, declaration, mayBeRenamedBuiltIn, reporter, context, arg_0));
    }

    private static final Unit check$lambda$0(Ref.BooleanRef $reported, FirSimpleFunction $declaration, boolean $mayBeRenamedBuiltIn, DiagnosticReporter $reporter, CheckerContext $context, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FirSimpleFunction hiddenFir = (FirSimpleFunction)it.getFir();
        if (!$reported.element && Intrinsics.areEqual(DeprecationUtilsKt.isHiddenToOvercomeSignatureClash(hiddenFir), true)) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = hiddenFir;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL) && Intrinsics.areEqual(SignatureUtilsKt.computeJvmDescriptor$default($declaration, null, false, null, 7, null), SignatureUtilsKt.computeJvmDescriptor$default(hiddenFir, null, false, null, 7, null))) {
                FirNamedFunctionSymbol firNamedFunctionSymbol = ClassMembersKt.getInitialSignatureAttr(hiddenFir);
                if (firNamedFunctionSymbol == null) {
                    return Unit.INSTANCE;
                }
                FirNamedFunctionSymbol regularBase = firNamedFunctionSymbol;
                String description2 = $mayBeRenamedBuiltIn ? "a renamed function" : "a function with erased parameters";
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$declaration.getSource(), FirJvmErrors.INSTANCE.getACCIDENTAL_OVERRIDE_CLASH_BY_JVM_SIGNATURE(), (Object)it, (Object)description2, (Object)regularBase, (DiagnosticContext)$context, null, 64, null);
                $reported.element = true;
            }
        }
        return Unit.INSTANCE;
    }
}

