/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedForWarningConeSubstitutor;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedTypeForWarningAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001aG\u0010\r\u001a\u00020\u0005*\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a9\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "checkConditionForEnhancedTypeMismatch", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "", "factory", "checkExpressionForEnhancedTypeMismatch", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;)V", "actualType", "Lkotlin/Pair;", "getEnhancedTypesForComparison", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lkotlin/Pair;"})
public final class FirExpressionJavaNullabilityWarningCheckersKt {
    private static final void checkConditionForEnhancedTypeMismatch(FirExpression $this$checkConditionForEnhancedTypeMismatch, CheckerContext context, DiagnosticReporter reporter) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch($this$checkConditionForEnhancedTypeMismatch, context.getSession().getBuiltinTypes().getBooleanType().getConeType(), reporter, context, FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
    }

    public static final void checkExpressionForEnhancedTypeMismatch(@NotNull FirExpression $this$checkExpressionForEnhancedTypeMismatch, @Nullable ConeKotlinType expectedType, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context, @NotNull KtDiagnosticFactory3<ConeKotlinType, ConeKotlinType, String> factory2) {
        Intrinsics.checkNotNullParameter($this$checkExpressionForEnhancedTypeMismatch, "<this>");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(factory2, "factory");
        if (expectedType == null) {
            return;
        }
        ConeKotlinType actualType = FirTypeUtilsKt.getResolvedType($this$checkExpressionForEnhancedTypeMismatch);
        Pair<ConeKotlinType, ConeKotlinType> pair = FirExpressionJavaNullabilityWarningCheckersKt.getEnhancedTypesForComparison(actualType, expectedType, context);
        if (pair == null) {
            return;
        }
        Pair<ConeKotlinType, ConeKotlinType> pair2 = pair;
        ConeKotlinType actualTypeForComparison = pair2.component1();
        ConeKotlinType expectedTypeForComparison = pair2.component2();
        if (!TypeUtilsKt.isSubtypeOf(actualTypeForComparison, TypeComponentsKt.getTypeContext(context.getSession()), expectedTypeForComparison) && TypeUtilsKt.isSubtypeOf(actualType, TypeComponentsKt.getTypeContext(context.getSession()), expectedType)) {
            String string2;
            if (EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(actualType) || EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(expectedType)) {
                LanguageVersion languageVersion = LanguageFeature.SupportJavaErrorEnhancementOfArgumentsOfWarningLevelEnhanced.getSinceVersion();
                String versionString = languageVersion != null ? languageVersion.getVersionString() : null;
                string2 = "This will become an error in Kotlin " + versionString + ". See https://youtrack.jetbrains.com/issue/KT-63209";
            } else {
                string2 = "";
            }
            String suffix = string2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkExpressionForEnhancedTypeMismatch.getSource(), factory2, (Object)actualTypeForComparison, (Object)expectedTypeForComparison, (Object)suffix, (DiagnosticContext)context, null, 64, null);
        }
    }

    private static final Pair<ConeKotlinType, ConeKotlinType> getEnhancedTypesForComparison(ConeKotlinType actualType, ConeKotlinType expectedType, CheckerContext context) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType actualTypeForComparison;
        if (actualType == null || expectedType == null) {
            return null;
        }
        if (actualType instanceof ConeErrorType || expectedType instanceof ConeErrorType) {
            return null;
        }
        EnhancedForWarningConeSubstitutor substitutor2 = new EnhancedForWarningConeSubstitutor(TypeComponentsKt.getTypeContext(context.getSession()));
        ConeKotlinType enhancedActualType = substitutor2.substituteOrNull(actualType);
        ConeKotlinType enhancedExpectedType = substitutor2.substituteOrNull(expectedType);
        if (enhancedActualType == null && enhancedExpectedType == null) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = enhancedActualType;
        if (coneKotlinType2 == null) {
            coneKotlinType2 = actualTypeForComparison = actualType;
        }
        if ((coneKotlinType = enhancedExpectedType) == null) {
            coneKotlinType = expectedType;
        }
        ConeKotlinType expectedTypeForComparison = coneKotlinType;
        return TuplesKt.to(actualTypeForComparison, expectedTypeForComparison);
    }

    public static final /* synthetic */ void access$checkConditionForEnhancedTypeMismatch(FirExpression $receiver, CheckerContext context, DiagnosticReporter reporter) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkConditionForEnhancedTypeMismatch($receiver, context, reporter);
    }
}

