/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a'\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a?\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a/\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "expression", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "checkFieldAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "fieldSymbol", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingFile", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "dispatchReceiver", "checkClashWithInvisibleProperty", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkClashWithCompanionProperty", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V"})
public final class FirFieldAccessShadowedByInvisibleKotlinPropertyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void checkFieldAccess(FirQualifiedAccessExpression expression, CheckerContext context, DiagnosticReporter reporter) {
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperFieldAccessGenerationForFieldAccessShadowedByKotlinProperty)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression);
        if (!(firCallableSymbol instanceof FirFieldSymbol)) return;
        FirFieldSymbol firFieldSymbol = (FirFieldSymbol)firCallableSymbol;
        if (firFieldSymbol == null) {
            return;
        }
        FirFieldSymbol fieldSymbol = firFieldSymbol;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = fieldSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual($this$isJavaOrEnhancement$iv$iv, FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object e = $this$isJavaOrEnhancement$iv.getFir();
            if (!(e instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)e;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) {
            return;
        }
        FirFile firFile = context.getContainingFile();
        if (firFile == null) {
            return;
        }
        FirFile containingFile = firFile;
        FirExpression firExpression = expression.getDispatchReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression dispatchReceiver = firExpression;
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithInvisibleProperty(context, fieldSymbol, containingFile, dispatchReceiver, reporter, expression);
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithCompanionProperty(context, fieldSymbol, reporter, expression);
    }

    private static final void checkClashWithInvisibleProperty(CheckerContext context, FirFieldSymbol fieldSymbol, FirFile containingFile, FirExpression dispatchReceiver, DiagnosticReporter reporter, FirQualifiedAccessExpression expression) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(dispatchReceiver), context.getSession(), context.getScopeSession(), CallableCopyTypeCalculator.Forced.INSTANCE, null);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope2 = firTypeScope;
        List<FirVariableSymbol<?>> properties2 = FirScopeKt.getProperties(scope2, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties2) {
            boolean isVisible;
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property) || (isVisible = FirVisibilityCheckerKt.isVisible(FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()), (FirCallableSymbol)property, context.getSession(), containingFile, context.getContainingDeclarations(), dispatchReceiver))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getSource(), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, (DiagnosticContext)context, null, 16, null);
            break;
        }
    }

    private static final void checkClashWithCompanionProperty(CheckerContext context, FirFieldSymbol fieldSymbol, DiagnosticReporter reporter, FirQualifiedAccessExpression expression) {
        Object object = expression.getDispatchReceiver();
        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, context.getSession())) == null) {
            return;
        }
        Object dispatchReceiverClass = object;
        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClassSymbol)dispatchReceiverClass).getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionClass = firRegularClassSymbol;
        FirTypeScope companionScope = FirHelpersKt.unsubstitutedScope(companionClass, context);
        List<FirVariableSymbol<?>> properties2 = FirScopeKt.getProperties(companionScope, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties2) {
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getSource(), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, (DiagnosticContext)context, null, 16, null);
            break;
        }
    }

    public static final /* synthetic */ void access$checkFieldAccess(FirQualifiedAccessExpression expression, CheckerContext context, DiagnosticReporter reporter) {
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkFieldAccess(expression, context, reporter);
    }
}

