/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamInterfaceConstructorReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJavaSamInterfaceConstructorReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJavaSamInterfaceConstructorReferenceChecker INSTANCE = new FirJavaSamInterfaceConstructorReferenceChecker();

    private FirJavaSamInterfaceConstructorReferenceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(expression instanceof FirCallableReferenceAccess)) {
            return;
        }
        FirNamedReference firNamedReference = ((FirCallableReferenceAccess)expression).getCalleeReference();
        if (!(firNamedReference instanceof FirResolvedNamedReference)) return;
        FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firNamedReference;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirBasedSymbol<?> referredSymbol = reference.getResolvedSymbol();
        if (!(referredSymbol instanceof FirNamedFunctionSymbol)) return;
        if (!Intrinsics.areEqual(((FirNamedFunctionSymbol)referredSymbol).getOrigin(), FirDeclarationOrigin.SamConstructor.INSTANCE)) return;
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirNamedFunctionSymbol)referredSymbol).getResolvedReturnTypeRef(), context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol samClassSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isFun$iv = samClassSymbol;
        boolean $i$f$isFun = false;
        if (!$this$isFun$iv.getRawStatus().isFun()) return;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = samClassSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual($this$isJavaOrEnhancement$iv$iv, FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object e = $this$isJavaOrEnhancement$iv.getFir();
            if (!(e instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)e;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reference.getSource(), FirJvmErrors.INSTANCE.getJAVA_SAM_INTERFACE_CONSTRUCTOR_REFERENCE(), (DiagnosticContext)context, null, 8, null);
    }
}

