/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.AbstractFirUnnecessarySafeCallChecker;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedForWarningConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaUnnecessarySafeCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirUnnecessarySafeCallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "expression", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
public final class FirJavaUnnecessarySafeCallChecker
extends AbstractFirUnnecessarySafeCallChecker {
    @NotNull
    public static final FirJavaUnnecessarySafeCallChecker INSTANCE = new FirJavaUnnecessarySafeCallChecker();

    private FirJavaUnnecessarySafeCallChecker() {
    }

    @Override
    public void check(@NotNull FirSafeCallExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType coneKotlinType2 = new EnhancedForWarningConeSubstitutor(TypeComponentsKt.getTypeContext(context.getSession())).substituteOrNull(FirTypeUtilsKt.getResolvedType(expression.getReceiver()));
        if (coneKotlinType2 == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType2, context.getSession(), null, 2, null)) == null) {
            return;
        }
        ConeKotlinType receiverType = coneKotlinType;
        this.checkSafeCallReceiverType(receiverType, expression.getSource(), context, reporter);
    }
}

