/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.java.VirtualFileBasedSourceElement;
import org.jetbrains.kotlin.fir.modules.FirJavaModuleResolverProviderKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J1\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012J5\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmModuleAccessibilityQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClassAccess", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkClassAccess$checkers_jvm", "checkPackageAccess", "fileFromPackage", "Lcom/intellij/openapi/vfs/VirtualFile;", "referencedPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "checkPackageAccess$checkers_jvm", "checkers.jvm"})
public final class FirJvmModuleAccessibilityQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJvmModuleAccessibilityQualifiedAccessChecker INSTANCE = new FirJvmModuleAccessibilityQualifiedAccessChecker();

    private FirJvmModuleAccessibilityQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        if (callableSymbol.getOrigin().getFromSource()) {
            return;
        }
        ConeClassLikeLookupTag containingClass = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (containingClass != null) {
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(containingClass, context.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            this.checkClassAccess$checkers_jvm(context, containingClassSymbol, expression, reporter);
        } else {
            DeserializedContainerSource deserializedContainerSource = callableSymbol.getContainerSource();
            JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
            if (jvmPackagePartSource == null) {
                return;
            }
            JvmPackagePartSource containerSource = jvmPackagePartSource;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = containerSource.getKnownJvmBinaryClass();
            Object object = kotlinJvmBinaryClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
            Object virtualFile = object;
            FqName fqName2 = containerSource.getClassName().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "getPackageFqName(...)");
            this.checkPackageAccess$checkers_jvm(context, (VirtualFile)virtualFile, fqName2, expression, reporter);
        }
    }

    public final void checkClassAccess$checkers_jvm(@NotNull CheckerContext context, @NotNull FirClassSymbol<?> symbol, @NotNull FirElement element, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (symbol.getOrigin().getFromSource()) {
            return;
        }
        SourceElement sourceElement = DeclarationAttributesKt.getSourceElement((FirClassLikeDeclaration)symbol.getFir());
        SourceElement sourceElement2 = sourceElement;
        if (sourceElement2 instanceof VirtualFileBasedSourceElement) {
            object = ((VirtualFileBasedSourceElement)sourceElement).getVirtualFile();
        } else if (sourceElement2 instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)sourceElement).getBinaryClass();
            object = kotlinJvmBinaryClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
        } else {
            return;
        }
        VirtualFile virtualFile = object;
        this.checkPackageAccess$checkers_jvm(context, virtualFile, UtilsKt.packageFqName((FirBasedSymbol)symbol), element, reporter);
    }

    public final void checkPackageAccess$checkers_jvm(@NotNull CheckerContext context, @NotNull VirtualFile fileFromPackage, @NotNull FqName referencedPackageFqName, @NotNull FirElement element, @NotNull DiagnosticReporter reporter) {
        JavaModuleResolver.AccessError accessError;
        Object source;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(fileFromPackage, "fileFromPackage");
        Intrinsics.checkNotNullParameter(referencedPackageFqName, "referencedPackageFqName");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirFile firFile = context.getContainingFile();
        KtSourceFile ktSourceFile = firFile != null ? firFile.getSourceFile() : null;
        KtVirtualFileSourceFile ktVirtualFileSourceFile = ktSourceFile instanceof KtVirtualFileSourceFile ? (KtVirtualFileSourceFile)ktSourceFile : null;
        VirtualFile fileFromOurModule = ktVirtualFileSourceFile != null ? ktVirtualFileSourceFile.getVirtualFile() : null;
        JavaModuleResolver.AccessError accessError2 = FirJavaModuleResolverProviderKt.getJavaModuleResolverProvider(context.getSession()).getJavaModuleResolver().checkAccessibility(fileFromOurModule, fileFromPackage, referencedPackageFqName);
        if (accessError2 == null) {
            return;
        }
        JavaModuleResolver.AccessError diagnostic = accessError2;
        Object object = ReferenceUtilsKt.toReference(element, context.getSession());
        if (object == null || (object = ((FirReference)object).getSource()) == null) {
            object = source = element.getSource();
        }
        if ((accessError = diagnostic) instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_EXPORT_PACKAGE(), (Object)((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic).getDependencyModuleName(), (Object)referencedPackageFqName.asString(), (DiagnosticContext)context, null, 32, null);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE(), (Object)((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic).getDependencyModuleName(), (DiagnosticContext)context, null, 16, null);
        } else if (Intrinsics.areEqual(accessError, JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE(), (DiagnosticContext)context, null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

