/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPlatformSpecificCastChecker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeCastChecker;", "Lorg/jetbrains/kotlin/fir/FirPlatformSpecificCastChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fromType", "toType", "", "shouldSuppressImpossibleCast", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "forwardDeclarationType", "isCastToAForwardDeclaration", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z"})
public final class FirNativeCastChecker
extends FirPlatformSpecificCastChecker {
    @NotNull
    public static final FirNativeCastChecker INSTANCE = new FirNativeCastChecker();

    private FirNativeCastChecker() {
    }

    @Override
    public boolean shouldSuppressImpossibleCast(@NotNull FirSession session, @NotNull ConeKotlinType fromType, @NotNull ConeKotlinType toType) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(fromType, "fromType");
        Intrinsics.checkNotNullParameter(toType, "toType");
        return this.isCastToAForwardDeclaration(session, toType);
    }

    private final boolean isCastToAForwardDeclaration(FirSession session, ConeKotlinType forwardDeclarationType) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(forwardDeclarationType, session);
        return (firRegularClassSymbol != null ? FirNativeHelpersKt.forwardDeclarationKindOrNull(firRegularClassSymbol) : null) != null;
    }
}

