/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.NativeForwardDeclarationKind;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\n\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationClassId", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "error", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "reportIfHasAnnotation", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/name/NativeForwardDeclarationKind;", "forwardDeclarationKindOrNull", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Lorg/jetbrains/kotlin/name/NativeForwardDeclarationKind;"})
public final class FirNativeHelpersKt {
    public static final void reportIfHasAnnotation(@NotNull DiagnosticReporter $this$reportIfHasAnnotation, @NotNull FirDeclaration declaration, @NotNull ClassId annotationClassId, @NotNull KtDiagnosticFactory0 error, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$reportIfHasAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
        Intrinsics.checkNotNullParameter(error, "error");
        Intrinsics.checkNotNullParameter(context, "context");
        FirAnnotation annotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, annotationClassId, context.getSession());
        if (annotation != null) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportIfHasAnnotation, (AbstractKtSourceElement)annotation.getSource(), error, (DiagnosticContext)context, null, 8, null);
        }
    }

    @Nullable
    public static final NativeForwardDeclarationKind forwardDeclarationKindOrNull(@NotNull FirRegularClassSymbol $this$forwardDeclarationKindOrNull) {
        Intrinsics.checkNotNullParameter($this$forwardDeclarationKindOrNull, "<this>");
        return NativeForwardDeclarationKind.Companion.getPackageFqNameToKind().get($this$forwardDeclarationKindOrNull.getClassId().getPackageFqName());
    }
}

