/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeObjCOverrideInitChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOverrideInitChecker INSTANCE = new FirNativeObjCOverrideInitChecker();

    private FirNativeObjCOverrideInitChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session = context.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration.getSymbol(), context.getSession())) {
            FirNativeObjCOverrideInitChecker.check$checkKotlinObjCClass(session, reporter, context, declaration);
        }
    }

    private static final Unit check$constructors$lambda$0(List $result, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ((Collection)$result).add(it);
        return Unit.INSTANCE;
    }

    private static final List<FirConstructorSymbol> check$constructors(FirClassSymbol<?> $this$check_u24constructors, FirSession session) {
        List result2 = new ArrayList();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(session, $this$check_u24constructors, null).processDeclaredConstructors(arg_0 -> FirNativeObjCOverrideInitChecker.check$constructors$lambda$0(result2, arg_0));
        return result2;
    }

    private static final boolean check$overridesConstructor(FirConstructorSymbol $this$check_u24overridesConstructor, FirConstructorSymbol other) {
        boolean bl;
        block4: {
            List<FirValueParameterSymbol> aParams = $this$check_u24overridesConstructor.getValueParameterSymbols();
            List<FirValueParameterSymbol> bParams = other.getValueParameterSymbols();
            if (aParams.size() != bParams.size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)aParams, (Iterable)bParams);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirValueParameterSymbol thisParameter = (FirValueParameterSymbol)pair.component1();
                    FirValueParameterSymbol otherParameter = (FirValueParameterSymbol)pair.component2();
                    if (Intrinsics.areEqual(thisParameter.getName(), otherParameter.getName()) && Intrinsics.areEqual(thisParameter.getResolvedReturnType(), otherParameter.getResolvedReturnType())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$checkCanGenerateOverrideInit(FirSession session, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass, FirConstructor constructor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull(firClass, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        FirRegularClassSymbol superClass = SupertypeUtilsKt.getSuperClassSymbolOrAny(((FirRegularClass)firClass).getSymbol(), session);
        Iterable $this$filter$iv = FirNativeObjCOverrideInitChecker.check$constructors(superClass, session);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirConstructorSymbol it = (FirConstructorSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirNativeObjCOverrideInitChecker.check$overridesConstructor(constructor.getSymbol(), it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superConstructors = CollectionsKt.toList((List)destination$iv$iv);
        FirConstructorSymbol firConstructorSymbol = (FirConstructorSymbol)CollectionsKt.singleOrNull(superConstructors);
        if (firConstructorSymbol == null) {
            FirNativeObjCOverrideInitChecker $this$check_u24checkCanGenerateOverrideInit_u24lambda_u243 = INSTANCE;
            boolean bl = false;
            if (superConstructors.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_DOES_NOT_OVERRIDE_ANY_SUPER_CONSTRUCTOR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_MATCHES_SEVERAL_SUPER_CONSTRUCTORS(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            }
            return;
        }
        FirConstructorSymbol superConstructor = firConstructorSymbol;
        FirFunctionSymbol<?> firFunctionSymbol = FirObjCInteropKt.getObjCInitMethod(superConstructor, session);
        Intrinsics.checkNotNull(firFunctionSymbol);
        FirFunctionSymbol<?> initMethod = firFunctionSymbol;
        Iterable $this$forEach$iv = ((FirRegularClass)firClass).getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirSimpleFunction) || !FirHelpersKt.getDirectOverriddenSymbols((FirCallableDeclaration)it, $context).contains(initMethod) || ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableDeclaration)it)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_OVERRIDES_ALREADY_OVERRIDDEN_OBJC_INITIALIZER(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
        }
    }

    private static final void check$checkKotlinObjCClass(FirSession session, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirConstructor) || !FirAnnotationUtilsKt.hasAnnotation(((FirConstructor)decl).getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId(), session)) continue;
            FirNativeObjCOverrideInitChecker.check$checkCanGenerateOverrideInit(session, $reporter, $context, firClass, (FirConstructor)decl);
        }
    }
}

